/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.server.context;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.remoteskin.server.context.CRemoteSkinServerContext;
import de.sillysky.nyssr.impl.remoteskin.server.context.IDependencies;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContextFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import org.jetbrains.annotations.NotNull;

class CRemoteSkinServerContextFactory
implements IService,
IRemoteSkinServerContextFactory {
    private final IDependencies mDependencies;

    CRemoteSkinServerContextFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    @NotNull
    public CRemoteSkinServerContext createContext(@NotNull IRemoteSkinClientContext aClientContext, @NotNull IId aNID) throws CException {
        CRemoteSkinServerContext context = new CRemoteSkinServerContext(this.mDependencies, aClientContext);
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(aNID);
        ns.getTargetRegistry().registerTarget((ITarget)context);
        this.mDependencies.getRemoteSkinConnector().addContext(aClientContext.getId(), aClientContext.getTargetAddress(), aClientContext.getPlatformType());
        return context;
    }

    @NotNull
    public IRemoteSkinServerContext createContext(@NotNull IId aNID) throws CException {
        CRemoteSkinServerContext context = new CRemoteSkinServerContext(this.mDependencies);
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(aNID);
        assert (ns != null);
        ns.getTargetRegistry().registerTarget((ITarget)context);
        return context;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IRemoteSkinServerContextFactory.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }
}

