/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.server.widgetset.loader;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.json.IJsonCompactWriter;
import de.sillysky.nyssr.json.IJsonParser;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.server.widgetset.loader.IWidgetSetLoader;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.hash.CUtilMd5;
import de.sillysky.nyssr.util.stream.CUtilStream;
import de.sillysky.nyssr.util.swing.icon.CIconHelper;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

class CWidgetSetLoader
implements IService,
IWidgetSetLoader {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWidgetSetLoader.class);
    private static final String[] IMAGE_EXTENSIONS = new String[]{"png", "jpeg", "ico", "jpg"};
    private static final String RESOURCE = "resource";
    private static final String BYTES = "bytes";
    private final boolean mRemoveResource = true;
    private IJsonCompactWriter mWriter;
    private IJsonParser mParser;

    CWidgetSetLoader() {
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mParser = (IJsonParser)aServiceRegistry.getServiceOrThrow(IJsonParser.class);
        this.mWriter = (IJsonCompactWriter)aServiceRegistry.getServiceOrThrow(IJsonCompactWriter.class);
        aServiceRegistry.registerService(IWidgetSetLoader.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        aServiceRegistry.deregisterService((Object)this);
    }

    public String loadJson(@NotNull Class<?> aParent, @NotNull String aPath) throws CException {
        String string;
        block8: {
            InputStream stream = aParent.getResourceAsStream(aPath);
            try {
                byte[] bytes = CUtilStream.readByteArrayFully((InputStream)stream);
                String json = new String(bytes, StandardCharsets.UTF_8);
                CJsonObject jo = this.mParser.parse(json, true);
                this.parseIcons(aParent, jo);
                StringBuilder sb = new StringBuilder(json.length());
                this.mWriter.write(sb, (Object)jo);
                string = sb.toString();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Error on loading JSON file {}", new Object[]{aPath});
                    throw new CException(2).append((Object)e);
                }
            }
            stream.close();
        }
        return string;
    }

    private void parseIcons(@NotNull Class<?> aParent, @NotNull CJsonObject aJsonObject) {
        for (String key : aJsonObject.keys()) {
            Object oResource = aJsonObject.getValue(key);
            if (oResource instanceof String) {
                byte[] bb;
                String resource;
                String key1 = key.toLowerCase();
                if (!RESOURCE.equals(key1) || !this.isImage(resource = (String)oResource) || (bb = CIconHelper.loadBytesFromJar(aParent, (String)((String)oResource))) == null || bb.length <= 0) continue;
                String encoded = CUtilMd5.toBase64((byte[])bb);
                aJsonObject.put(BYTES, (Object)encoded);
                aJsonObject.remove(RESOURCE);
                continue;
            }
            if (oResource instanceof CJsonObject) {
                this.parseIcons(aParent, (CJsonObject)oResource);
                continue;
            }
            if (!(oResource instanceof CJsonArray)) continue;
            this.parseIcons(aParent, (CJsonArray)oResource);
        }
    }

    private boolean isImage(@NotNull String aValue) {
        String value = aValue.toLowerCase();
        for (String ext : IMAGE_EXTENSIONS) {
            if (!value.contains(ext)) continue;
            return true;
        }
        return false;
    }

    private void parseIcons(@NotNull Class<?> aParent, @NotNull CJsonArray aJsonArray) {
        for (Object o : aJsonArray.getChildren()) {
            if (o instanceof CJsonObject) {
                this.parseIcons(aParent, (CJsonObject)o);
                continue;
            }
            if (!(o instanceof CJsonArray)) continue;
            this.parseIcons(aParent, (CJsonArray)o);
        }
    }
}

