/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.parser.json;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.record.db.CRecordEntry;
import de.sillysky.nyssr.impl.record.db.CSlotEntry;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.json.IJsonParser;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.record.db.EAccess;
import de.sillysky.nyssr.record.db.ETransportDirection;
import de.sillysky.nyssr.record.db.IRecordDatabase;
import de.sillysky.nyssr.record.db.IRecordEntry;
import de.sillysky.nyssr.record.db.ISlotRecord;
import de.sillysky.nyssr.record.parser.json.IRecordParserJson;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.slot.ISlotFactory;
import de.sillysky.nyssr.util.CUtilString;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CRecordParserJson
implements IService,
IRecordParserJson {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRecordParserJson.class);
    private ISlotFactory mSlotFactory;
    @Nullable
    private IJsonParser mJsonParser;

    CRecordParserJson() {
    }

    static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(ISlotFactory.class);
        aDependencyList.add(IJsonParser.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mSlotFactory = (ISlotFactory)aServiceRegistry.getService(ISlotFactory.class);
        this.mJsonParser = (IJsonParser)aServiceRegistry.getService(IJsonParser.class);
        aServiceRegistry.registerService(IRecordParserJson.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @NotNull
    private EAccess parseAccess(CJsonObject aRecord) {
        EAccess access = EAccess.PUBLIC;
        String accessString = this.parseString(aRecord, "access", null);
        if (accessString != null) {
            access = EAccess.valueOf((String)accessString);
        }
        return access;
    }

    private boolean parseBoolean(@NotNull CJsonObject aJSONObject, @NotNull String aKey, boolean aDefault) {
        String isServiceString = this.parseString(aJSONObject, aKey, null);
        if (isServiceString != null) {
            return Boolean.parseBoolean(isServiceString);
        }
        return aDefault;
    }

    @Override
    public Collection<IId> parseFile(@NotNull IRecordDatabase aDb, @NotNull Path aPath) throws CException {
        ArrayList<IId> list = new ArrayList<IId>();
        try {
            byte[] bytes = Files.readAllBytes(aPath);
            String text = new String(bytes, StandardCharsets.UTF_8);
            assert (this.mJsonParser != null);
            CJsonObject root = this.mJsonParser.parse(text, false);
            Object obj = root.getValue("records");
            CUtilCheck.checkNotNullEx((Object)(obj instanceof CJsonArray), (String)"JSON: Array records not found.", (Object[])new Object[0]);
            if (obj instanceof CJsonArray) {
                this.parseRecords(aDb, list, (CJsonArray)obj);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error parsing the JSON file {}", new Object[]{aPath});
            throw new CException(2105).append((Object)e);
        }
        return list;
    }

    private void parseRecord(@NotNull IRecordDatabase aDb, List<IId> aList, CJsonObject aRecord) throws CException {
        Object obj;
        String description;
        String id = this.parseString(aRecord, "id", null);
        if (CUtilString.isEmpty((String)id)) {
            LOG.error("No ID found. Skip");
            return;
        }
        String name = this.parseString(aRecord, "name", null);
        if (CUtilString.isEmpty((String)name)) {
            LOG.error("No Name found. Skip");
            return;
        }
        boolean isService = this.parseBoolean(aRecord, "isService", false);
        EAccess access = this.parseAccess(aRecord);
        CRecordEntry recordEntry = new CRecordEntry(id, name, isService, access);
        boolean hasOtherSlots = this.parseBoolean(aRecord, "hasOtherSlots", false);
        recordEntry.setHasOtherSlots(hasOtherSlots);
        String namespaces = this.parseString(aRecord, "namespaces", null);
        if (namespaces != null) {
            recordEntry.addNamespace(namespaces);
        }
        if ((description = this.parseString(aRecord, "description", null)) != null) {
            recordEntry.setDescription(description);
        }
        if ((obj = aRecord.getValue("slots")) instanceof CJsonArray) {
            this.parseSlots((CJsonArray)obj, recordEntry);
        }
        aDb.addRecord((IRecordEntry)recordEntry);
        aList.add(recordEntry.getId());
    }

    private void parseRecords(@NotNull IRecordDatabase aDb, List<IId> aList, CJsonArray aRecords) throws CException {
        for (Object o : aRecords.getChildren()) {
            if (!(o instanceof CJsonObject)) continue;
            this.parseRecord(aDb, aList, (CJsonObject)o);
        }
    }

    private CSlotEntry parseSlot(CJsonObject aSlot) throws CException {
        String key = this.parseString(aSlot, "key", "");
        if (CUtilString.isEmpty((String)key)) {
            LOG.error("Whether slot type nor slot id available; skip slot");
            return null;
        }
        String name = this.parseString(aSlot, "name", null);
        if (CUtilString.isEmpty((String)name)) {
            LOG.error("Empty slot name; skip slot");
            return null;
        }
        String type = this.parseString(aSlot, "type", null);
        if (type == null) {
            throw new CException(2105).append("Unknown type");
        }
        ETransportDirection direction = this.parseTransportDirection(aSlot);
        boolean mandatory = this.parseBoolean(aSlot, "mandatory", false);
        CSlotEntry slotRecord = new CSlotEntry(this.mSlotFactory, key, type, name, direction, mandatory);
        String description = this.parseString(aSlot, "description", null);
        if (description != null) {
            slotRecord.setDescription(description);
        }
        return slotRecord;
    }

    private void parseSlots(CJsonArray aSlots, CRecordEntry aRecordEntry) throws CException {
        for (Object o : aSlots.getChildren()) {
            CSlotEntry slot;
            if (!(o instanceof CJsonObject) || (slot = this.parseSlot((CJsonObject)o)) == null) continue;
            aRecordEntry.addSlot((ISlotRecord)slot);
        }
    }

    @Nullable
    private String parseString(@NotNull CJsonObject aObject, @NotNull String aKey, @Nullable String aDefault) {
        String key = aKey.toLowerCase();
        Collection set = aObject.keys();
        for (String keyOfObject : set) {
            Object value;
            String key1 = keyOfObject.toLowerCase();
            if (!key.equals(key1) || !((value = aObject.getValue(keyOfObject)) instanceof String)) continue;
            return (String)value;
        }
        return aDefault;
    }

    private ETransportDirection parseTransportDirection(CJsonObject aSlot) {
        ETransportDirection direction = ETransportDirection.REQUEST;
        String text = this.parseString(aSlot, "direction", null);
        if (text != null) {
            direction = ETransportDirection.valueOf((String)text);
        } else {
            boolean isAnswer;
            text = this.parseString(aSlot, "answer", null);
            if (text != null && (isAnswer = Boolean.parseBoolean(text))) {
                direction = ETransportDirection.ANSWER;
            }
        }
        return direction;
    }
}

