/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.registry.service;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.microservice.registry.records.CRecordMicroServiceInstance;
import de.sillysky.nyssr.record.CRecord;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMicroServiceInstanceEntry {
    private final IId mMicroServiceId;
    private final IId mInstanceId;
    private CTargetAddress mTargetAddress;
    private final ZonedDateTime mTimeAdded;
    private ZonedDateTime mTimeRefreshed = ZonedDateTime.now();

    public CMicroServiceInstanceEntry(@NotNull IId aMicroServiceId, @NotNull IId aInstanceId, @NotNull CTargetAddress aTargetAddress, @Nullable ZonedDateTime aTimeAdded) {
        this.mMicroServiceId = aMicroServiceId;
        this.mTargetAddress = aTargetAddress;
        this.mInstanceId = aInstanceId;
        this.mTimeAdded = aTimeAdded == null ? ZonedDateTime.now() : aTimeAdded;
    }

    @NotNull
    public IId getMicroServiceId() {
        return this.mMicroServiceId;
    }

    @NotNull
    public CTargetAddress getTargetAddress() {
        return this.mTargetAddress;
    }

    @NotNull
    public ZonedDateTime getTimeAdded() {
        return this.mTimeAdded;
    }

    @NotNull
    public ZonedDateTime getTimeRefreshed() {
        return this.mTimeRefreshed;
    }

    @NotNull
    public IId getInstanceId() {
        return this.mInstanceId;
    }

    void refresh(@NotNull CTargetAddress aTargetAddress) {
        this.mTargetAddress = aTargetAddress;
        this.mTimeRefreshed = ZonedDateTime.now();
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CMicroServiceInstanceEntry that = (CMicroServiceInstanceEntry)aO;
        return this.mInstanceId.equals((Object)that.mInstanceId);
    }

    public int hashCode() {
        return Objects.hash(this.mInstanceId);
    }

    public String toString() {
        return String.valueOf(this.mInstanceId) + "(" + String.valueOf(this.mTargetAddress) + ")";
    }

    @NotNull
    public CRecord toRecord() throws CException {
        CRecord record = CRecordMicroServiceInstance.create();
        CRecordMicroServiceInstance.setMicroServiceId((CRecord)record, (IId)this.mMicroServiceId);
        CRecordMicroServiceInstance.setMicroServiceInstanceId((CRecord)record, (IId)this.mInstanceId);
        CRecordMicroServiceInstance.setMicroServiceAddress((CRecord)record, (CTargetAddress)this.mTargetAddress);
        CRecordMicroServiceInstance.setTimeAdded((CRecord)record, (ZonedDateTime)this.mTimeAdded);
        return record;
    }
}

