/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordFileStoreCheckFiles
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"97d776b7-c3d7-4c4f-9ec7-29be36ce7d21");
    public static final String NAME = "FileStoreCheckFiles";
    public static final String DESCRIPTION = "Check if the files are up-to-date.";
    public static final String SLOT_DIRTY_FILE_PATHS = "2";
    public static final String SLOT_FILES = "1";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String[] getDirtyFilePaths(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DIRTY_FILE_PATHS);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static CRecord[] getFiles(@NotNull CRecord aRecord, CRecord[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILES);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord[])slot.getValue();
    }

    public static void setDirtyFilePaths(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_DIRTY_FILE_PATHS, slot);
    }

    public static void setFiles(@NotNull CRecord aRecord, CRecord[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_FILES, slot);
    }
}

