/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.ENotification;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CWidgetList {
    private LinkedHashMap<CWidgetId, CWidget> mMap = new LinkedHashMap();

    CWidgetList() {
    }

    public void add(@NotNull CWidget aWidget) {
        this.mMap.put(aWidget.getId(), aWidget);
    }

    public void addAll(@NotNull CWidgetList aWidgets) {
        for (CWidget w : aWidgets.getAll()) {
            this.add(w);
        }
    }

    CWidget findPlaceHolder() {
        for (CWidget w : this.mMap.values()) {
            String widgetType = w.getWidgetType();
            if (!"PlaceHolder".equalsIgnoreCase(widgetType)) continue;
            return w;
        }
        return null;
    }

    @Nullable
    public CWidget get(@NotNull String aKey) {
        String key = CUtilNormalize.normalize((String)aKey);
        for (Map.Entry<CWidgetId, CWidget> e : this.mMap.entrySet()) {
            String name = e.getKey().getName();
            if (!name.equals(key)) continue;
            return e.getValue();
        }
        return null;
    }

    public CWidget get(@NotNull CWidgetId aKey) {
        return this.mMap.get(aKey);
    }

    Collection<CWidget> getAll() {
        return new ArrayList<CWidget>(this.mMap.values());
    }

    public void getRootWidgets(@NotNull Collection<CWidget> aToFill) {
        for (CWidget w : this.mMap.values()) {
            if (w.getParent() != null) continue;
            aToFill.add(w);
        }
    }

    public void remove(@NotNull CWidget aWidget) {
        this.mMap.remove(aWidget.getId());
    }

    void replaceWidget(@NotNull CWidget aWidgetToReplace, @NotNull CWidget aReplacement, boolean aChildrenOnly) {
        LinkedHashMap<CWidgetId, CWidget> newMap = new LinkedHashMap<CWidgetId, CWidget>();
        for (Map.Entry<CWidgetId, CWidget> e : this.mMap.entrySet()) {
            CWidgetId k = e.getKey();
            CWidget v = e.getValue();
            if (v == aWidgetToReplace) {
                if (aChildrenOnly) {
                    for (CWidget child : aReplacement.children()) {
                        newMap.put(child.getId(), child);
                    }
                    continue;
                }
                newMap.put(aReplacement.getId(), aReplacement);
                continue;
            }
            newMap.put(k, v);
        }
        this.mMap = newMap;
    }

    public int size() {
        return this.mMap.size();
    }

    public void notifyWidgets(ENotification aNotification, Object ... aObjects) {
        for (CWidget widget : this.mMap.values()) {
            widget.notifyWidget(aNotification, aObjects);
        }
    }

    @Nullable
    public CWidget findComponent(@NotNull Component aComponent) {
        for (CWidget w : this.mMap.values()) {
            if (aComponent != w.getComponent()) continue;
            return w;
        }
        return null;
    }

    public void dump(@NotNull StringBuilder aSb, int aLeadingTabCount, String aFilter) {
        Collection<CWidget> values;
        CWidget first;
        CWidget rootWidget;
        if (!this.mMap.isEmpty() && (rootWidget = (first = (values = this.mMap.values()).iterator().next()).getWidgetSet().getRootWidget()) != null) {
            rootWidget.dump(aSb, aLeadingTabCount, aFilter);
        }
    }
}

