/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.enums.EDropMode;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import javax.swing.DropMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventDropMode
implements IRemoteSkinEvent {
    static final String KEY_MODE = "mode";
    private static final EDropMode DEFAULT_MODE = EDropMode.on;
    private final EDropMode mMode;

    public CEventDropMode(@NotNull EDropMode aMode) {
        this.mMode = aMode;
    }

    @Nullable
    public static CEventDropMode create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            return CEventDropMode.convertString(jo.getValue(KEY_MODE));
        }
        return CEventDropMode.convertString(aValue);
    }

    @Nullable
    private static CEventDropMode convertString(@Nullable Object aValue) {
        if (aValue instanceof String) {
            EDropMode mode = (EDropMode)((Object)CUtilEnum.fromString(EDropMode.class, (String)((String)aValue), (Object)((Object)DEFAULT_MODE)));
            return new CEventDropMode(mode);
        }
        return null;
    }

    public DropMode getSwingConstant() {
        switch (this.mMode) {
            case on: {
                return DropMode.ON;
            }
            case insert: {
                return DropMode.INSERT;
            }
            case onOrInsert: {
                return DropMode.ON_OR_INSERT;
            }
        }
        return DropMode.USE_SELECTION;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mMode != DEFAULT_MODE) {
            jo.put(KEY_MODE, (Object)this.mMode.name());
        }
        return jo;
    }

    public EDropMode getMode() {
        return this.mMode;
    }
}

