/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.enums.EEditChangeType;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTextChangeNotification
implements IRemoteSkinEvent {
    public static final String TYPE = "type";
    public static final String TEXT = "text";
    public static final String OFFSET = "offset";
    public static final String LENGTH = "length";
    public static final String CARET = "caret";
    private final EEditChangeType mType;
    private final String mText;
    private final int mOffset;
    private final int mLength;
    private final int mCaretPosition;

    public CEventTextChangeNotification(@NotNull EEditChangeType aType, @NotNull String aText, int aOffset, int aLength, int aCaretPosition) {
        this.mType = aType;
        this.mText = aText;
        this.mOffset = aOffset;
        this.mLength = aLength;
        this.mCaretPosition = aCaretPosition;
    }

    @Nullable
    public static CEventTextChangeNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String s = CUtilJsonString.fromJson((CJsonObject)jo, (String)TYPE, (String)EEditChangeType.change.name());
            EEditChangeType type = (EEditChangeType)((Object)CUtilEnum.fromString(EEditChangeType.class, (String)s, (Object)((Object)EEditChangeType.unknown)));
            String text = CUtilJsonString.fromJson((CJsonObject)jo, (String)TEXT, (String)"");
            int offset = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)OFFSET, (int)0);
            int length = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)LENGTH, (int)0);
            int caret = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)CARET, (int)0);
            return new CEventTextChangeNotification(type, text, offset, length, caret);
        }
        return null;
    }

    public int getCaretPosition() {
        return this.mCaretPosition;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(TYPE, (Object)this.mType.name());
        jo.put(TEXT, (Object)this.mText);
        jo.put(OFFSET, (Object)this.mOffset);
        jo.put(LENGTH, (Object)this.mLength);
        jo.put(CARET, (Object)this.mCaretPosition);
        return jo;
    }

    @NotNull
    public String getText() {
        return this.mText;
    }

    @NotNull
    public EEditChangeType getType() {
        return this.mType;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getLength() {
        return this.mLength;
    }
}

