/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetSetId;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventWidgetSetMountedNotification
implements IRemoteSkinEvent {
    private static final String TRANSACTION_ID = "transactionid";
    private static final String WIDGET_SET_ID = "widgetsetid";
    private final CWidgetSetId mWidgetSetId;
    private final UUID mTransactionId;

    public CEventWidgetSetMountedNotification(CWidgetSetId aWidgetSetId, UUID aTransactionId) {
        this.mWidgetSetId = aWidgetSetId;
        this.mTransactionId = aTransactionId;
    }

    @Nullable
    public static CEventWidgetSetMountedNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            UUID transactionId = null;
            Object o = jo.getValue(WIDGET_SET_ID);
            CEventWidgetSetId toMount = CEventWidgetSetId.create(o);
            if (toMount == null) {
                return null;
            }
            String s = CUtilString.fromObject((Object)jo.getValue(TRANSACTION_ID), (String)"");
            if (CUtilString.isValid((String)s)) {
                transactionId = CUtilUuid.fromString((String)s);
            }
            return new CEventWidgetSetMountedNotification(toMount.getWidgetSetId(), transactionId);
        }
        return null;
    }

    @NotNull
    public CJsonObject toJson() {
        CJsonObject jo = new CJsonObject(true);
        CEventWidgetSetId dws = new CEventWidgetSetId(this.mWidgetSetId);
        jo.put(WIDGET_SET_ID, dws.toJson());
        if (this.mTransactionId != null) {
            jo.put(TRANSACTION_ID, (Object)this.mTransactionId.toString());
        }
        return jo;
    }

    public CWidgetSetId getWidgetSetId() {
        return this.mWidgetSetId;
    }

    public UUID getTransactionId() {
        return this.mTransactionId;
    }
}

