/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.todo;

import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventReference {
    public static final String PREFIX_WIDGET_SET = "@";
    public static final String PREFIX_WIDGET = "#";
    public static final String PREFIX_INSTANCE = "*";
    public static final String COLON = ",";
    private final String mWidgetName;
    private final String mWidgetSetName;
    private final String mWidgetSetInstance;

    public CEventReference(@Nullable String aWidgetName, @Nullable String aWidgetSetName, @Nullable String aWidgetSetInstance) {
        this.mWidgetName = aWidgetName;
        this.mWidgetSetName = aWidgetSetName;
        this.mWidgetSetInstance = aWidgetSetInstance;
    }

    @Nullable
    public String getWidgetSetName() {
        return this.mWidgetSetName;
    }

    @Nullable
    public String getWidgetIdName() {
        return this.mWidgetName;
    }

    @Nullable
    public String getWidgetSetInstance() {
        return this.mWidgetSetInstance;
    }

    @NotNull
    public String toJson() {
        StringBuilder sb = new StringBuilder(120);
        if (this.mWidgetSetName != null) {
            sb.append(this.mWidgetSetName);
        }
        sb.append('.');
        if (this.mWidgetSetInstance != null) {
            sb.append(this.mWidgetSetInstance);
        }
        sb.append('.');
        if (this.mWidgetName != null) {
            sb.append(this.mWidgetName);
        }
        return sb.toString();
    }

    @Nullable
    public static CEventReference create(@Nullable Object aValue) {
        if (aValue instanceof String) {
            String value = (String)aValue;
            String[] split = value.split("[.]");
            if (split.length == 3 && (CUtilString.isValid((String)split[0]) || CUtilString.isValid((String)split[2]))) {
                return new CEventReference(split[0], split[1], split[2]);
            }
            String w = null;
            String ws = null;
            String wsi = null;
            for (String s : split = value.split(COLON)) {
                if (CEventReference.isWidgetId(s)) {
                    w = s;
                    continue;
                }
                if (CEventReference.isWidgetSet(s)) {
                    ws = s;
                    continue;
                }
                if (!CEventReference.isWidgetSetInstance(s)) continue;
                wsi = s;
            }
        }
        return null;
    }

    static boolean isWidgetSet(@Nullable String aId) {
        if (CUtilString.isValid((String)aId)) {
            return aId.startsWith(PREFIX_WIDGET_SET);
        }
        return false;
    }

    static boolean isWidgetSetInstance(@Nullable String aId) {
        if (CUtilString.isValid((String)aId)) {
            return aId.startsWith(PREFIX_INSTANCE);
        }
        return false;
    }

    static boolean isWidgetId(@Nullable String aId) {
        if (CUtilString.isValid((String)aId)) {
            return aId.startsWith(PREFIX_WIDGET);
        }
        return false;
    }
}

