/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.database.example;

import de.sillysky.nyssr.impl.database.example.CConfigurationDto;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.time.stopwatch.CStopWatch;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class CTableConfiguration {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTableConfiguration.class);
    private final Connection mConnection;
    private final CStopWatch mWatch = new CStopWatch();

    CTableConfiguration(Connection aConnection) {
        this.mConnection = aConnection;
        this.createTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS configuration(configuration_name VARCHAR not null,key VARCHAR not null,value VARCHAR,disabled BOOLEAN,constraint IF NOT EXISTS TABLE_CONFIGURATION_PK primary key (configuration_name,key))";
        this.mWatch.start();
        try (PreparedStatement statement = this.mConnection.prepareStatement("CREATE TABLE IF NOT EXISTS configuration(configuration_name VARCHAR not null,key VARCHAR not null,value VARCHAR,disabled BOOLEAN,constraint IF NOT EXISTS TABLE_CONFIGURATION_PK primary key (configuration_name,key))");){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "Error createTable: ");
        }
        finally {
            this.mWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllForConfiguration(String aConfigurationName) {
        String sql = "DELETE FROM configuration WHERE configuration_name=?";
        this.mWatch.start();
        try (PreparedStatement statement = this.mConnection.prepareStatement("DELETE FROM configuration WHERE configuration_name=?");){
            statement.setString(1, aConfigurationName);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "Error deleteAllForConfiguration: ");
        }
        finally {
            this.mWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProperty(String aConfigurationName, String aKey) {
        String sql = "DELETE FROM configuration WHERE configuration_name=? AND key=?";
        this.mWatch.start();
        try (PreparedStatement statement = this.mConnection.prepareStatement("DELETE FROM configuration WHERE configuration_name=? AND key=?");){
            statement.setString(1, aConfigurationName);
            statement.setString(2, aKey);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "Error deleteProperty: ");
        }
        finally {
            this.mWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getConfigurationNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.isClosed()) {
            String sql = "SELECT DISTINCT configuration_name FROM configuration";
            this.mWatch.start();
            try (PreparedStatement statement = this.mConnection.prepareStatement("SELECT DISTINCT configuration_name FROM configuration");){
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    String configurationName = rs.getString(1);
                    list.add(configurationName);
                }
            }
            catch (SQLException e) {
                LOG.error((Throwable)e, "Error getConfigurationNames: ");
            }
            finally {
                this.mWatch.stop();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CStringProperties getProperties(@NotNull String aConfigurationName) {
        CStringProperties result = new CStringProperties();
        if (!this.isClosed()) {
            String sql = "SELECT key, value FROM configuration WHERE configuration_name=? AND disabled=false";
            this.mWatch.start();
            try (PreparedStatement statement = this.mConnection.prepareStatement("SELECT key, value FROM configuration WHERE configuration_name=? AND disabled=false");){
                statement.setString(1, aConfigurationName);
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    String key = rs.getString(1);
                    String value = rs.getString(2);
                    result.put(key, value);
                }
            }
            catch (SQLException e) {
                LOG.error((Throwable)e, "Error getProperties: ");
            }
            finally {
                this.mWatch.stop();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CConfigurationDto getRecord(String aConfigurationName, String aKey) {
        String sql = "SELECT value FROM configuration WHERE configuration_name=? AND key=? AND disabled=false";
        this.mWatch.start();
        CConfigurationDto result = null;
        try (PreparedStatement statement = this.mConnection.prepareStatement("SELECT value FROM configuration WHERE configuration_name=? AND key=? AND disabled=false");){
            statement.setString(1, aConfigurationName);
            statement.setString(2, aKey);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                String value = rs.getString(1);
                result = new CConfigurationDto(aConfigurationName, aKey, value);
            }
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "Error getRecord: ");
            result = null;
        }
        finally {
            this.mWatch.stop();
        }
        return result;
    }

    public void insert(CConfigurationDto aDto) {
        this.insert(aDto.getConfigurationName(), aDto.getKey(), aDto.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String aConfigurationName, String aKey, String aValue) {
        String sql = "INSERT INTO configuration (configuration_name,key,value) VALUES (?,?,?)";
        this.mWatch.start();
        try (PreparedStatement statement = this.mConnection.prepareStatement("INSERT INTO configuration (configuration_name,key,value) VALUES (?,?,?)");){
            statement.setString(1, aConfigurationName);
            statement.setString(2, aKey);
            statement.setString(3, aValue);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "Error insert: ");
        }
        finally {
            this.mWatch.stop();
        }
    }

    public void insert(String aConfigurationName, CStringProperties aProperties) {
        for (String key : aProperties.getKeys()) {
            this.insert(aConfigurationName, key, aProperties.get(key));
        }
    }

    private boolean isClosed() {
        boolean result = true;
        try {
            result = this.mConnection.isClosed();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (result) {
            LOG.warn("ConfigurationTable is closed.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProperty(String aConfigurationName, String aKey, String aValue) {
        String sql = "UPDATE configuration SET value=? WHERE configuration_name=? AND key=?";
        this.mWatch.start();
        try (PreparedStatement statement = this.mConnection.prepareStatement("UPDATE configuration SET value=? WHERE configuration_name=? AND key=?");){
            statement.setString(1, aValue);
            statement.setString(2, aConfigurationName);
            statement.setString(3, aKey);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "Error updateProperty: ");
        }
        finally {
            this.mWatch.stop();
        }
    }
}

