/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.local;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.file.store.api.EFileDeliveryType;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreRequestFile;
import de.sillysky.nyssr.impl.software.updater.local.CDownloadRequest;
import de.sillysky.nyssr.impl.software.updater.local.CSerialJobMachine;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.job.serial.ISerialJobQueueEntry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CJobDownloadDirectory
extends CTarget
implements ISerialJobQueueEntry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CJobDownloadDirectory.class);
    private final ITargetRegistry mTargetRegistry;
    private final CSerialJobMachine mParent;
    private final String mDirName;
    private final Path mDestinationPath;
    private final Map<String, CDownloadRequest> mDownloadRequests;

    CJobDownloadDirectory(@NotNull ITargetRegistry aTargetRegistry, @NotNull CSerialJobMachine aParent, @NotNull String aDirName, @NotNull Map<String, CDownloadRequest> aFiles, @NotNull Path aDestinationPath) {
        this.mTargetRegistry = aTargetRegistry;
        this.mParent = aParent;
        this.mDirName = aDirName;
        this.mDownloadRequests = aFiles;
        this.mDestinationPath = aDestinationPath;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordFileStoreRequestFile.ID, this::asyncRequestFile);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        try {
            if (!this.requestMissingFiles()) {
                this.mParent.jobFinished(this);
            }
        }
        catch (CException aException) {
            LOG.error("Error on download files: {}", new Object[]{aException.toString()});
            this.mParent.finish(aException.getCode(), aException.getMessage());
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRequestFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            if (!result.hasSuccess()) {
                this.mParent.finish(result.getCode(), result.getText());
                return true;
            }
            String path = CRecordFileStoreRequestFile.getPath((CRecord)aRecord, null);
            String hash = CRecordFileStoreRequestFile.getHash((CRecord)aRecord, null);
            File file = (File)CRecordFileStoreRequestFile.getFile((CRecord)aRecord, null);
            CDownloadRequest request = this.getFileFromMap(hash, path);
            if (file == null || request == null) {
                this.mParent.finish(15, "Error copying " + path);
                return true;
            }
            file = file.getAbsoluteFile();
            request.setFile(file);
            String relativePath = request.getRelativePath();
            Path newPath = this.mDestinationPath.resolve(relativePath).toAbsolutePath();
            try {
                Files.copy(file.toPath(), newPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException aException) {
                LOG.error("Couldn't copy file {} to new Directory: {}", new Object[]{file, aException.getMessage()});
                this.mParent.finish(2, "Error copying " + String.valueOf(newPath));
                return true;
            }
            if (this.checkWhetherAllFilesArePresent()) {
                this.mParent.jobFinished(this);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public String getId() {
        return "Downloader" + this.mDirName;
    }

    public void stop() {
        this.deregisterTarget();
    }

    public void start() throws CException {
        this.mTargetRegistry.registerTarget((ITarget)this);
    }

    private CDownloadRequest getFileFromMap(@Nullable String aHash, @NotNull String aPath) {
        Object key = aPath;
        if (CUtilString.isValid((String)aHash)) {
            key = (String)key + "(" + aHash + ")";
        }
        return this.mDownloadRequests.get(key);
    }

    private boolean checkWhetherAllFilesArePresent() {
        for (CDownloadRequest request : this.mDownloadRequests.values()) {
            File file = request.getFile();
            if (file != null) continue;
            System.out.println("File ending: " + request.getRelativePath());
            return false;
        }
        System.out.println("All files downloaded.");
        return true;
    }

    private boolean requestMissingFiles() throws CException {
        boolean requestRunning = false;
        for (CDownloadRequest request : this.mDownloadRequests.values()) {
            File file = request.getFile();
            if (file != null) continue;
            requestRunning = true;
            String path = request.getRelativePath();
            String hash = request.getHash();
            this.requestFile(hash, path);
        }
        return requestRunning;
    }

    private void requestFile(@Nullable String aHash, @NotNull String aRelativePath) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordFileStoreRequestFile.class);
        CRecord record = CRecordFileStoreRequestFile.create();
        CRecordFileStoreRequestFile.setPath((CRecord)record, (String)aRelativePath);
        if (CUtilString.isValid((String)aHash)) {
            CRecordFileStoreRequestFile.setHash((CRecord)record, (String)aHash);
        }
        CRecordFileStoreRequestFile.setDeliveryType((CRecord)record, (byte)EFileDeliveryType.FILE.getType());
        this.sendRequest(env, record);
    }
}

