/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.enums.EWidgetOrientation;
import de.sillysky.nyssr.remoteskin.model.events.CEventText;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetOrientation;
import de.sillysky.nyssr.util.CUtilInteger;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingProgressBar
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingProgressBar.class);
    private final JProgressBar mComponent = new JProgressBar();

    CSwingProgressBar(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("borderPainted", this::applyBorderPainted);
        list.addHandler("indeterminateMode", this::applyIndeterminateMode);
        list.addHandler("minimum", this::applyMinimum);
        list.addHandler("maximum", this::applyMaximum);
        list.addHandler("orientation", this::applyOrientation);
        list.addHandler("showText", this::applyShowText);
        list.addHandler("text", this::applyText);
        list.addHandler("valueInt", this::applyValueInteger);
        list.addHandler("value", this::applyValueInteger);
    }

    private boolean applyBorderPainted(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            LOG.debug("Set BorderPainted to {}", new Object[]{enabled});
            this.mComponent.setBorderPainted(enabled);
            return true;
        }
        return false;
    }

    private boolean applyIndeterminateMode(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            LOG.debug("Set Indeterminate Mode to {}", new Object[]{enabled});
            this.mComponent.setIndeterminate(enabled);
            return true;
        }
        return false;
    }

    private boolean applyMinimum(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int min = CUtilInteger.fromObject((Object)aValue, (int)1);
            LOG.debug("Set minimum to {}", new Object[]{min});
            this.getComponent().setMinimum(min);
            return true;
        }
        return false;
    }

    private boolean applyMaximum(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int max = CUtilInteger.fromObject((Object)aValue, (int)10);
            LOG.debug("Set maximum to {}", new Object[]{max});
            this.getComponent().setMaximum(max);
            return true;
        }
        return false;
    }

    private boolean applyOrientation(@NotNull String aKey, @Nullable Object aValue) {
        CEventWidgetOrientation event = CEventWidgetOrientation.create((Object)aValue);
        if (event != null) {
            EWidgetOrientation orientation = event.getOrientation();
            LOG.debug("Set orientation to {}", new Object[]{orientation});
            switch (orientation) {
                case horizontal: {
                    this.getComponent().setOrientation(0);
                    return true;
                }
                case vertical: {
                    this.getComponent().setOrientation(1);
                    return true;
                }
            }
            LOG.error("Unknown Orientation: {}", new Object[]{orientation});
        }
        return false;
    }

    private boolean applyText(@NotNull String aKey, @Nullable Object aValue) {
        CEventText event = CEventText.create((Object)aValue);
        if (event != null) {
            this.mComponent.setString(event.getText());
            return true;
        }
        return false;
    }

    private boolean applyShowText(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            this.mComponent.setStringPainted(enabled);
            return true;
        }
        return false;
    }

    private boolean applyValueInteger(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int value = CUtilInteger.fromObject((Object)aValue, (int)0);
            LOG.debug("Set value to {}", new Object[]{value});
            this.getComponent().setValue(value);
            return true;
        }
        return false;
    }

    @NotNull
    public JProgressBar getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.ProgressBar.name();
    }
}

