/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingComponent;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EFileDeliveryType;
import de.sillysky.nyssr.remoteskin.model.ENotification;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.enums.ETabPlacement;
import de.sillysky.nyssr.remoteskin.model.events.CEventAddTab;
import de.sillysky.nyssr.remoteskin.model.events.CEventBackgroundAt;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventTabPlacement;
import de.sillysky.nyssr.remoteskin.model.events.CEventTabProperties;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingTabbedPane
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingTabbedPane.class);
    private final Map<Component, Color> mBackgrounds = new HashMap<Component, Color>();
    private final JTabbedPane mComponent = new JTabbedPane();
    private Color mBackgroundColorForAll = null;
    private boolean mUseChangeListener = false;

    CSwingTabbedPane(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("activateTab", this::applyActivate);
        list.addHandler("backgroundAt", this::applyBackgroundAt);
        list.addHandler("onStateChanged", this::applyOnStateChanged);
        list.addHandler("tabPlacement", this::applyTabPlacement);
        list.addHandler("addTab", this::applyAddTab);
        list.addHandler("tabColor", this::applyTabColor);
        list.addHandler("activeTabColor", this::applyActiveTabColor);
        list.addHandler("tabProperties", this::applyTabProperties);
    }

    static int getIndexOfTabByComponent(@NotNull JTabbedPane aTabbedPane, @NotNull Component aComponent) {
        int tabCount = aTabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Component component = aTabbedPane.getComponentAt(i);
            if (component != aComponent) continue;
            return i;
        }
        return -1;
    }

    public static int getIndexOfTabByTitle(@NotNull JTabbedPane aTabbedPane, @NotNull String aTitle) {
        String s = aTitle.toLowerCase();
        int tabCount = aTabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            String tabTitle = aTabbedPane.getTitleAt(i).toLowerCase();
            if (!tabTitle.equals(s)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.mComponent.addChangeListener(this::onChange);
    }

    private boolean applyTabProperties(@NotNull String aKey, @Nullable Object aValue) {
        CEventTabProperties event = CEventTabProperties.create((Object)aValue);
        if (event != null) {
            CWidgetId tabComponent = event.getComponent();
            CWidget widget = this.getWidgetSet().getContext().findWidget(tabComponent);
            if (widget == null) {
                LOG.error("AddTabProperties: Widget {} not found.", new Object[]{tabComponent});
            } else {
                int index = CSwingTabbedPane.getIndexOfTabByComponent(this.getComponent(), widget.getComponent());
                if (index < 0) {
                    LOG.error("AddTabProperties: Component {} not found in TabbedPane.", new Object[]{tabComponent});
                } else {
                    CEventColor eventColor;
                    String title = event.getTitle();
                    if (CUtilString.isValid((String)title)) {
                        this.getComponent().setTitleAt(index, title);
                    }
                    if ((eventColor = event.getColor()) != null) {
                        this.getComponent().setBackgroundAt(index, eventColor.createColor());
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean applyActiveTabColor(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            UIManager.put("TabbedPane.selected", event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyActivate(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            JTabbedPane tab = this.getComponent();
            String s = CUtilString.fromObject((Object)aValue, null);
            if (s != null) {
                String title = s.toLowerCase();
                int tabCount = tab.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    String tabTitle = tab.getTitleAt(i).toLowerCase();
                    if (!tabTitle.equals(title)) continue;
                    LOG.debug("Activate Tab {}.", new Object[]{title});
                    tab.setSelectedIndex(i);
                    break;
                }
                LOG.warn("Activate Tab: Tab {} not found.", new Object[]{title});
                return true;
            }
        }
        return false;
    }

    private boolean applyAddTab(@NotNull String aKey, @Nullable Object aValue) throws Exception {
        CWidget w;
        CEventAddTab event = CEventAddTab.create((Object)aValue);
        if (event != null && (w = this.getWidgetSet().getContext().findOrMountWidgetSet((CWidget)this, event.getWidgetSetId())) != null) {
            this.addChildWidget(w);
            Component childComponent = w.getComponent();
            String iconPath = event.getIconPath();
            if (!iconPath.isEmpty()) {
                this.getWidgetSet().getContext().requestFile(iconPath, w.getId(), (Object)"tabImage", EFileDeliveryType.AS_IMAGE);
            }
            this.addTab(event.getTitle(), null, childComponent, event.getToolTip());
            return true;
        }
        return false;
    }

    private boolean applyBackgroundAt(@NotNull String aKey, @Nullable Object aValue) {
        Component component;
        CEventBackgroundAt event = CEventBackgroundAt.create((Object)aValue);
        if (event != null && (component = this.getComponent().getTabComponentAt(event.getIndex())) != null) {
            component.setBackground(event.getColor());
            return true;
        }
        return false;
    }

    private void applyColors(@Nullable Component aComponent) {
        JTabbedPane tab;
        int index;
        if (aComponent != null && (index = CSwingTabbedPane.getIndexOfTabByComponent(tab = this.getComponent(), aComponent)) >= 0) {
            Color color = this.mBackgrounds.get(aComponent);
            if (color == null) {
                color = this.mBackgroundColorForAll;
            }
            if (color != null) {
                tab.setBackgroundAt(index, color);
                Component tabComponentAt = tab.getTabComponentAt(index);
                if (tabComponentAt != null) {
                    tabComponentAt.setBackground(color);
                }
            }
        }
    }

    private boolean applyOnStateChanged(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mUseChangeListener = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyTabColor(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            this.setBackgroundToAll(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyTabPlacement(@NotNull String aKey, @Nullable Object aValue) {
        CEventTabPlacement event = CEventTabPlacement.create((Object)aValue);
        if (event != null) {
            JTabbedPane tab = this.getComponent();
            ETabPlacement tabPlacement = event.getTabPlacement();
            switch (tabPlacement) {
                case left: {
                    tab.setTabPlacement(2);
                    break;
                }
                case right: {
                    tab.setTabPlacement(4);
                    break;
                }
                case bottom: {
                    tab.setTabPlacement(3);
                    break;
                }
                default: {
                    tab.setTabPlacement(1);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void addChildComponent(@NotNull CWidget aChild) {
        JTabbedPane tab = this.getComponent();
        CUtilCheck.checkNotNull((Object)tab, (String)"TabbedPane is null", (Object[])new Object[0]);
        Component child = aChild.getComponent();
        CUtilCheck.checkNotNull((Object)child, (String)"Child is null", (Object[])new Object[0]);
        String title = (String)aChild.getProperties().get("tabTitle");
        if (CUtilString.isEmpty((String)title)) {
            title = "TabTitle missing";
        }
        String tip = (String)aChild.getProperties().get("tooltip");
        String iconPath = (String)aChild.getProperties().get("icon");
        if (CUtilString.isValid((String)iconPath)) {
            this.getWidgetSet().getContext().requestFile(iconPath, aChild.getId(), (Object)"tabImage", EFileDeliveryType.AS_IMAGE);
        }
        this.addTab(title, null, child, tip);
    }

    private int addTab(@Nullable String aTitle, @Nullable ImageIcon aIcon, @NotNull Component aComponent, @Nullable String aTip) {
        JTabbedPane tab = this.getComponent();
        CUtilCheck.checkNotNull((Object)tab, (String)"TabbedPane is null", (Object[])new Object[0]);
        tab.addTab(aTitle, aIcon, aComponent, aTip);
        int index = tab.indexOfComponent(aComponent);
        this.applyColors(aComponent);
        return index;
    }

    private void setBackgroundToAll(@NotNull Color aColor) {
        JTabbedPane tab = this.getComponent();
        int tabCount = tab.getTabCount();
        this.mBackgroundColorForAll = aColor;
        for (int t = 0; t < tabCount; ++t) {
            tab.setBackgroundAt(t, aColor);
        }
    }

    @NotNull
    public JTabbedPane getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.TabbedPane.name();
    }

    @Override
    public void notifyWidget(@NotNull ENotification aNotification, Object ... aObjects) {
        if (aNotification == ENotification.GOT_CHILD && aObjects != null && aObjects[0] instanceof Component) {
            this.applyColors((Component)aObjects[0]);
        }
        super.notifyWidget(aNotification, aObjects);
    }

    private void onChange(@NotNull ChangeEvent aEvent) {
        if (this.mUseChangeListener) {
            this.addNotification("onChange", true);
            this.sendNotification();
        }
    }

    public void setTabColor(@NotNull CSwingComponent aComponent, @NotNull Color aColor) {
        JTabbedPane tab = this.getComponent();
        Component other = aComponent.getComponent();
        this.mBackgrounds.put(other, aColor);
        int index = CSwingTabbedPane.getIndexOfTabByComponent(tab, other);
        if (index >= 0) {
            tab.setBackgroundAt(index, aColor);
            Component tabComponentAt = tab.getTabComponentAt(index);
            if (tabComponentAt != null) {
                tabComponentAt.setBackground(aColor);
            }
        }
    }

    public void setTabImage(@NotNull CSwingComponent aComponent, @NotNull ImageIcon aImage) {
        Component other;
        JTabbedPane tab = this.getComponent();
        int index = CSwingTabbedPane.getIndexOfTabByComponent(tab, other = aComponent.getComponent());
        if (index >= 0) {
            tab.setIconAt(index, aImage);
        }
    }
}

