/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.enums.EPosition;
import de.sillysky.nyssr.remoteskin.model.enums.EWidgetOrientation;
import de.sillysky.nyssr.remoteskin.model.events.CEventMargin;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetOrientation;
import de.sillysky.nyssr.util.CUtilEnum;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import javax.swing.JToolBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingToolBar
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingToolBar.class);
    private final JToolBar mComponent = new JToolBar();

    CSwingToolBar(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("borderPainted", this::applyBorderPainted);
        list.addHandler("floatable", this::applyFloatable);
        list.addHandler("margin", this::applyMargin);
        list.addHandler("moveToolbar", this::applyMoveToolbar);
        list.addHandler("orientation", this::applyOrientation);
        list.addHandler("rolloverEnabled", this::applyRolloverEnabled);
    }

    private boolean applyBorderPainted(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean painted = (Boolean)aValue;
            this.mComponent.setBorderPainted(painted);
            return true;
        }
        return false;
    }

    private boolean applyFloatable(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            this.mComponent.setFloatable(enabled);
            return true;
        }
        return false;
    }

    private boolean applyMargin(@NotNull String aKey, @Nullable Object aValue) {
        CEventMargin event = CEventMargin.create((Object)aValue);
        if (event != null) {
            Insets insets = new Insets(event.getTop(), event.getLeft(), event.getBottom(), event.getRight());
            this.mComponent.setMargin(insets);
            return true;
        }
        return false;
    }

    private boolean applyMoveToolbar(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            EPosition position = (EPosition)CUtilEnum.fromString(EPosition.class, (String)((String)aValue), (Object)EPosition.north);
            String swingPosition = position.getSwingConstant();
            Container parent = this.mComponent.getParent();
            if (parent != null) {
                parent.remove(this.mComponent);
                parent.add((Component)this.mComponent, swingPosition);
                parent.revalidate();
                return true;
            }
        }
        return false;
    }

    private boolean applyOrientation(@NotNull String aKey, @Nullable Object aValue) {
        CEventWidgetOrientation event = CEventWidgetOrientation.create((Object)aValue);
        if (event != null) {
            EWidgetOrientation orientation = event.getOrientation();
            if (orientation == EWidgetOrientation.horizontal) {
                this.mComponent.setOrientation(0);
            } else {
                this.mComponent.setOrientation(1);
            }
            return true;
        }
        return false;
    }

    private boolean applyRolloverEnabled(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            this.mComponent.setRollover(enabled);
            return true;
        }
        return false;
    }

    @NotNull
    public JToolBar getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.ToolBar.name();
    }
}

