/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.listbox;

import de.sillysky.nyssr.impl.remoteskin.client.swing.util.CListItem;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.listbox.CListCellRenderer;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.listbox.CListModel;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.ENotification;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventDropMode;
import de.sillysky.nyssr.remoteskin.model.events.CEventEnsureVisible;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventListBoxLayout;
import de.sillysky.nyssr.remoteskin.model.events.CEventListContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionMode;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventMouseNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventPopupNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventSelectItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventSelectItems;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilIntegerArray;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingListBox
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingListBox.class);
    private final JList<CEventLabelItem> mComponent;
    private final CListModel mModel = new CListModel();
    private int mEnsureVisibleIndex;
    private Set<String> mSelectedItemsAtStartup = null;

    public CSwingListBox(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        this.mComponent = new JList<CEventLabelItem>(this.mModel);
        CListCellRenderer renderer = new CListCellRenderer();
        this.mComponent.setCellRenderer(renderer);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("clear", this::applyClear);
        list.addHandler("data", this::applyData);
        list.addHandler("drag", this::applyEnableDrag);
        list.addHandler("dropMode", this::applyDropMode);
        list.addHandler("ensureVisible", this::applyEnsureVisible);
        list.addHandler("fixedCellWidth", this::applyFixedCellWidth);
        list.addHandler("fixedCellHeight", this::applyFixedCellHeight);
        list.addHandler("listBoxLayout", this::applyListBoxLayout);
        list.addHandler("selectItem", this::applySelectItem);
        list.addHandler("selectItems", this::applySelectItems);
        list.addHandler("selectionBackground", this::applySelectionBackground);
        list.addHandler("selectionForeground", this::applySelectionForeground);
        list.addHandler("listSelectionMode", this::applyListSelectionMode);
        list.addHandler("visibleRowCount", this::applyVisibleRowCount);
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.mComponent.addListSelectionListener(this::valueChanged);
    }

    private boolean applyClear(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            if (enabled) {
                this.mComponent.setValueIsAdjusting(true);
                this.mModel.removeAllElements();
                this.mComponent.setValueIsAdjusting(false);
            }
            return true;
        }
        return false;
    }

    private boolean applyData(@NotNull String aKey, @Nullable Object aValue) {
        CEventListContent event = CEventListContent.create((Object)aValue);
        if (event != null) {
            this.mComponent.setValueIsAdjusting(true);
            this.mModel.removeAllElements();
            for (CEventLabelItem item : event.getItems()) {
                this.mModel.addEntry(item);
            }
            this.mComponent.setValueIsAdjusting(false);
            return true;
        }
        return false;
    }

    private boolean applyDropMode(@NotNull String aKey, @Nullable Object aValue) {
        CEventDropMode event = CEventDropMode.create((Object)aValue);
        if (event != null) {
            ((JList)this.getComponent()).setDropMode(event.getSwingConstant());
            return true;
        }
        return false;
    }

    private boolean applyEnableDrag(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            Component list = this.getComponent();
            boolean b = (Boolean)aValue;
            ((JList)list).setDragEnabled(b);
            return true;
        }
        return false;
    }

    private boolean applyEnsureVisible(@NotNull String aKey, @Nullable Object aValue) {
        CEventEnsureVisible event = CEventEnsureVisible.create((Object)aValue);
        if (event != null) {
            String id = event.getId();
            LOG.debug("{}: {}", new Object[]{aKey, id});
            CEventLabelItem entry = this.mModel.getById(id);
            if (entry != null) {
                int index = this.mModel.getIndexOfEntry(id);
                if (index >= 0) {
                    this.mEnsureVisibleIndex = index;
                    this.mComponent.ensureIndexIsVisible(this.mEnsureVisibleIndex);
                } else {
                    LOG.warn("Entry not visible: {}", new Object[]{id});
                }
            } else {
                LOG.error("Entry not found: {}", new Object[]{id});
            }
            return true;
        }
        return false;
    }

    private boolean applyFixedCellHeight(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            Component list = this.getComponent();
            int height = CUtilInteger.fromObject((Object)aValue, (int)-1);
            if (height >= 0) {
                ((JList)list).setFixedCellHeight(height);
                return true;
            }
        }
        return false;
    }

    private boolean applyFixedCellWidth(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            Component list = this.getComponent();
            int width = CUtilInteger.fromObject((Object)aValue, (int)-1);
            ((JList)list).setFixedCellWidth(width);
            return true;
        }
        return false;
    }

    private boolean applyListBoxLayout(@NotNull String aKey, @Nullable Object aValue) {
        CEventListBoxLayout event = CEventListBoxLayout.create((Object)aValue);
        if (event != null) {
            Component list = this.getComponent();
            ((JList)list).setLayoutOrientation(event.getSwingConstant());
            return true;
        }
        return false;
    }

    private boolean applySelectItem(@NotNull String aKey, @Nullable Object aValue) {
        CEventSelectItem event = CEventSelectItem.create((Object)aValue);
        if (event != null) {
            String itemId = event.getItemId();
            Container parent = this.mComponent.getParent();
            if (parent != null) {
                this.addSelection(itemId);
            } else {
                if (this.mSelectedItemsAtStartup == null) {
                    this.mSelectedItemsAtStartup = new HashSet<String>();
                }
                this.mSelectedItemsAtStartup.add(itemId);
            }
            return true;
        }
        return false;
    }

    private boolean applySelectItems(@NotNull String aKey, @Nullable Object aValue) {
        CEventSelectItems event = CEventSelectItems.create((Object)aValue);
        if (event != null) {
            Collection itemIds = event.getItemIds();
            Container parent = this.mComponent.getParent();
            if (parent != null) {
                this.setSelection((JList<CEventLabelItem>)this.getComponent(), itemIds);
            } else {
                if (this.mSelectedItemsAtStartup == null) {
                    this.mSelectedItemsAtStartup = new HashSet<String>();
                }
                this.mSelectedItemsAtStartup.addAll(itemIds);
            }
            return true;
        }
        return false;
    }

    private boolean applySelectionBackground(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor dc = CEventColor.create((Object)aValue);
        if (dc != null) {
            Component list = this.getComponent();
            ((JList)list).setSelectionBackground(dc.createColor());
            return true;
        }
        return false;
    }

    private boolean applySelectionForeground(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            Component list = this.getComponent();
            ((JList)list).setSelectionForeground(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyListSelectionMode(@NotNull String aKey, @Nullable Object aValue) {
        CEventListSelectionMode event = CEventListSelectionMode.create((Object)aValue);
        if (event != null) {
            Component list = this.getComponent();
            int mode = event.getSwingConstant();
            ((JList)list).setSelectionMode(mode);
            return true;
        }
        return false;
    }

    private boolean applyVisibleRowCount(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number || aValue instanceof String) {
            Component list = this.getComponent();
            int count = CUtilInteger.fromObject((Object)aValue, (int)-1);
            ((JList)list).setVisibleRowCount(count);
            ((Container)list).invalidate();
            Window windowAncestor = SwingUtilities.getWindowAncestor(list);
            if (windowAncestor != null) {
                windowAncestor.pack();
            }
            return true;
        }
        return false;
    }

    @Override
    public void notifyWidget(@NotNull ENotification aNotification, Object ... aObjects) {
        super.notifyWidget(aNotification, aObjects);
        if (aNotification == ENotification.SHOWN) {
            if (this.mEnsureVisibleIndex >= 0) {
                this.mComponent.ensureIndexIsVisible(this.mEnsureVisibleIndex);
                this.mEnsureVisibleIndex = -1;
            }
            if (this.mSelectedItemsAtStartup != null) {
                this.setSelection(this.mComponent, this.mSelectedItemsAtStartup);
            }
        }
    }

    @NotNull
    public JList<CEventLabelItem> getComponent() {
        return this.mComponent;
    }

    private int getIndexOfValue(String aValue) {
        Component list = this.getComponent();
        ListModel model = ((JList)list).getModel();
        for (int i = 0; i < ((JList)list).getModel().getSize(); ++i) {
            String text;
            CEventLabelItem elementAt = (CEventLabelItem)model.getElementAt(i);
            if (elementAt == null || !(text = elementAt.getAttributes().getDisplayedText()).equals(aValue)) continue;
            return i;
        }
        LOG.error("Value not found in list: {}", new Object[]{aValue});
        return -1;
    }

    @NotNull
    private CListItem getItem(@NotNull JList<CEventLabelItem> aList, @NotNull Point aPoint) {
        int index = aList.locationToIndex(aPoint);
        CEventLabelItem entry = aList.getModel().getElementAt(index);
        return new CListItem(index, entry.getId());
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.ListBox.name();
    }

    @NotNull
    private List<CEventLabelItem> getEntries() {
        Component listBox = this.getComponent();
        ListModel model = ((JList)listBox).getModel();
        ArrayList<CEventLabelItem> values = new ArrayList<CEventLabelItem>();
        for (int i = 0; i < model.getSize(); ++i) {
            CEventLabelItem entry = (CEventLabelItem)model.getElementAt(i);
            values.add(i, entry);
        }
        return values;
    }

    private void addSelection(@NotNull String aId) {
        Component listBox = this.getComponent();
        ListModel model = ((JList)listBox).getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            CEventLabelItem entry = (CEventLabelItem)model.getElementAt(i);
            if (!entry.getId().equals(aId)) continue;
            ((JList)listBox).getSelectionModel().addSelectionInterval(i, i);
        }
    }

    private void setSelection(@NotNull JList<CEventLabelItem> aList, @NotNull Collection<String> aSelected) {
        aList.clearSelection();
        List<CEventLabelItem> entries = this.getEntries();
        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
        block0: for (int i = 0; i < entries.size(); ++i) {
            CEventLabelItem entry = entries.get(i);
            for (String id : aSelected) {
                if (!entry.getId().equals(id)) continue;
                selectedIndexes.add(i);
                continue block0;
            }
        }
        int[] intArray = CUtilIntegerArray.fromIntegerCollection(selectedIndexes);
        aList.setSelectedIndices(intArray);
    }

    public void updatePopupItem(@NotNull MouseEvent aEvent) {
        super.updatePopupItem(aEvent);
        Point point = aEvent.getPoint();
        List popupEvents = this.getContext().getPopupEvents();
        popupEvents.add(point);
    }

    public void enrichMouseEvent(@NotNull CEventMouseNotification aEvent) {
        super.enrichMouseEvent(aEvent);
        CListItem item = this.getItem(this.mComponent, aEvent.getPosition());
        aEvent.setValue(item.getValue());
        aEvent.setRowId(Integer.toString(item.getIndex()));
    }

    public void enrichPopupEvent(@NotNull CEventPopupNotification aEvent) {
        super.enrichPopupEvent(aEvent);
        Point position = aEvent.getPosition();
        if (position != null) {
            CListItem item = this.getItem(this.mComponent, aEvent.getPosition());
            aEvent.setValue(item.getValue());
            aEvent.setRowId(Integer.toString(item.getIndex()));
        }
    }

    private void valueChanged(@NotNull ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int[] selectedIndices;
            CEventListSelectionNotification event = new CEventListSelectionNotification();
            for (int i : selectedIndices = ((JList)this.getComponent()).getSelectedIndices()) {
                CEventLabelItem entry = (CEventLabelItem)((JList)this.getComponent()).getModel().getElementAt(i);
                if (entry == null) continue;
                event.add(entry.getId());
            }
            this.addNotification("onListSelect", event.toJson());
            this.sendNotification();
        }
    }
}

