/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumn;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumnModel;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CRowModel;
import de.sillysky.nyssr.remoteskin.model.enums.EColumnType;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableCell;
import java.awt.Color;
import java.awt.Font;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CCell
implements Comparable<CCell> {
    private final CRowModel mRowModel;
    private final String mRowId;
    private final String mColumnId;
    private Object mValue;
    private Color mBackground;
    private Color mForeground;
    private Border mBorder;
    private Font mFont;

    CCell(@NotNull CRowModel aRowModel, @NotNull String aRowId, @NotNull String aColumnId) {
        this.mRowModel = aRowModel;
        this.mRowId = aRowId;
        this.mColumnId = aColumnId;
        this.mValue = "";
    }

    CRowModel getRowModel() {
        return this.mRowModel;
    }

    @Nullable
    Object getValue() {
        return this.mValue;
    }

    void setValue(@Nullable Object aValue) {
        this.mValue = aValue;
    }

    @NotNull
    String getRowId() {
        return this.mRowId;
    }

    @NotNull
    String getColumnId() {
        return this.mColumnId;
    }

    Color getBackground() {
        return this.mBackground;
    }

    void setBackground(@Nullable Color aBackground) {
        this.mBackground = aBackground;
    }

    Color getForeground() {
        return this.mForeground;
    }

    void setForeground(@Nullable Color aForeground) {
        this.mForeground = aForeground;
    }

    Border getBorder() {
        return this.mBorder;
    }

    void setBorder(@Nullable Border aBorder) {
        this.mBorder = aBorder;
    }

    Font getFont() {
        return this.mFont;
    }

    void setFont(@Nullable Font aFont) {
        this.mFont = aFont;
    }

    public void reset() {
        this.mFont = null;
        this.mBackground = null;
        this.mForeground = null;
        this.mBorder = null;
    }

    Border getTreeBorder() {
        return this.mBorder == null ? this.getColumnModel().getColumn(this.mColumnId).getTreeBorder() : this.mBorder;
    }

    public Color getTreeBackground() {
        return this.mBackground == null ? this.getColumnModel().getColumn(this.mColumnId).getTreeBackground() : this.mBackground;
    }

    public Color getTreeForeground() {
        return this.mForeground == null ? this.getColumnModel().getColumn(this.mColumnId).getTreeForeground() : this.mForeground;
    }

    public Font getTreeFont() {
        return this.mFont == null ? this.getColumnModel().getColumn(this.mColumnId).getTreeFont() : this.mFont;
    }

    @Override
    public int compareTo(@NotNull CCell aOther) {
        CColumnModel columnModel = this.getColumnModel();
        CColumn column = columnModel.getColumn(this.mColumnId);
        EColumnType type = column.getType();
        switch (type) {
            case bool: {
                Boolean value1 = this.mValue instanceof Boolean ? (Boolean)this.mValue : Boolean.FALSE;
                Boolean value2 = aOther.mValue instanceof Boolean ? (Boolean)aOther.mValue : Boolean.FALSE;
                return Boolean.compare(value1, value2);
            }
            case decimal: {
                Number value1 = this.mValue instanceof Number ? (Number)((Number)this.mValue) : (Number)0.0;
                Number value2 = aOther.mValue instanceof Number ? (Number)((Number)aOther.mValue) : (Number)0.0;
                return Double.compare(value1.doubleValue(), value2.doubleValue());
            }
        }
        String value1 = this.mValue.toString();
        String value2 = aOther.mValue.toString();
        return value1.compareTo(value2);
    }

    private CColumnModel getColumnModel() {
        return this.mRowModel.getTableModel().getColumnModel();
    }

    int getRowIndex() {
        return this.mRowModel.getRowIndex(this.mRowId);
    }

    int getColumnIndex() {
        return this.getColumnModel().getColumnIndex(this.mColumnId);
    }

    void setContent(@NotNull CEventTableCell aEvent) {
        Object value = aEvent.getLabelAttributes().getValue();
        this.setValue(value);
    }

    String getValueString() {
        return this.mValue == null ? "" : this.mValue.toString();
    }
}

