/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.db;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.record.db.IRecordDatabase;
import de.sillysky.nyssr.record.db.IRecordEntry;
import de.sillysky.nyssr.slot.ISlotFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CRecordDatabase
implements IRecordDatabase {
    private static final int HASH_MAP_SIZE_RECORDS = 200;
    private static final ILogger LOG = CLoggerFactory.getLogger(CRecordDatabase.class);
    private final INameDb mNameDb;
    private final ISlotFactory mSlotFactory;
    private final Map<IId, IRecordEntry> mRecords;

    CRecordDatabase(INameDb aNameDb, @NotNull ISlotFactory aSlotFactory) {
        LOG.info("create {}", new Object[]{this.getClass().getSimpleName()});
        this.mNameDb = aNameDb;
        this.mSlotFactory = aSlotFactory;
        this.mRecords = new HashMap<IId, IRecordEntry>(200);
    }

    @Override
    public boolean addRecord(@NotNull IRecordEntry aRecord) {
        boolean imported = false;
        IId mid = aRecord.getId();
        if (!this.mRecords.containsKey(mid)) {
            this.mRecords.put(mid, aRecord);
            if (this.mNameDb != null) {
                String name = aRecord.getName();
                this.mNameDb.getRecordIdDatabase().putName(mid, name);
            }
            imported = true;
        }
        return imported;
    }

    @Override
    @Nullable
    public IRecordEntry getRecord(@NotNull IId aId) {
        return this.mRecords.get(aId);
    }

    @Override
    @NotNull
    public Collection<String> getRecordIdStrings() {
        ArrayList<String> list = new ArrayList<String>();
        for (IId id : this.mRecords.keySet()) {
            list.add(id.valueToString());
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<IRecordEntry> getRecords() {
        Collection<IRecordEntry> values = this.mRecords.values();
        return Collections.unmodifiableCollection(values);
    }

    @Override
    @NotNull
    public ISlotFactory getSlotFactory() {
        return this.mSlotFactory;
    }

    @Override
    public int size() {
        return this.mRecords.size();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.mRecords.size() + ")";
    }
}

