/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.microservice.registry.helper.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNotifyMicroServiceRegistryCreated
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"2576540d-3e7f-47aa-840c-f32e59e99fc2");
    public static final String NAME = "NotifyMicroServiceRegistryCreated";
    public static final String DESCRIPTION = "Notification: a MicroService Registry has been created.";
    public static final String SLOT_MICRO_SERVICE_REGISTRY_ADDRESS = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getMicroServiceRegistryAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MICRO_SERVICE_REGISTRY_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static void setMicroServiceRegistryAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_MICRO_SERVICE_REGISTRY_ADDRESS, slot);
    }
}

