/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.client;

import de.sillysky.nyssr.impl.tcp.client.CTcpClientFactory;
import de.sillysky.nyssr.impl.tcp.client.IDependencies;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.tcp.ITcpConnectionFactory;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;

public final class CPackageTcpClient
implements IServiceStarter,
IDependencies {
    private IService mService;
    private INameDb mNameDb;
    private ITimerManager mTimerManager;
    private INamespaceFactory mNamespaceFactory;
    private ITcpConnectionFactory mTcpConnectionFactory;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(ITimerManager.class);
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(ITcpConnectionFactory.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNameDb = (INameDb)aServiceRegistry.getServiceOrThrow(INameDb.class);
            this.mTimerManager = (ITimerManager)aServiceRegistry.getServiceOrThrow(ITimerManager.class);
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
            this.mTcpConnectionFactory = (ITcpConnectionFactory)aServiceRegistry.getServiceOrThrow(ITcpConnectionFactory.class);
            this.mService = new CTcpClientFactory(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public INameDb getNameDb() {
        return this.mNameDb;
    }

    @Override
    @NotNull
    public ITimerManager getTimerManager() {
        return this.mTimerManager;
    }

    @Override
    @NotNull
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }

    @Override
    @NotNull
    public ITcpConnectionFactory getTcpConnectionFactory() {
        return this.mTcpConnectionFactory;
    }
}

