/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.factory;

import de.sillysky.nyssr.impl.tcp.factory.CTcpFactory;
import de.sillysky.nyssr.impl.tcp.factory.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.network.INetworkReady;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.tcp.ITcpClientFactory;
import de.sillysky.nyssr.tcp.ITcpServerFactory;
import org.jetbrains.annotations.NotNull;

public final class CPackageTcpFactory
implements IServiceStarter,
IDependencies {
    private IService mService;
    private IKernelConfiguration mKernelConfiguration;
    private ITcpClientFactory mTcpClientFactory;
    private ITcpServerFactory mTcpServerFactory;
    private INameDb mNameDb;
    private INamespaceFactory mNamespaceFactory;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(INameDb.class);
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(ITcpClientFactory.class);
        aDependencyList.add(ITcpServerFactory.class);
        aDependencyList.add(INetworkReady.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mKernelConfiguration = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mTcpClientFactory = (ITcpClientFactory)aServiceRegistry.getServiceOrThrow(ITcpClientFactory.class);
            this.mTcpServerFactory = (ITcpServerFactory)aServiceRegistry.getServiceOrThrow(ITcpServerFactory.class);
            this.mNameDb = (INameDb)aServiceRegistry.getServiceOrThrow(INameDb.class);
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
            this.mService = new CTcpFactory(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }

    @Override
    @NotNull
    public ITcpClientFactory getTcpClientFactory() {
        return this.mTcpClientFactory;
    }

    @Override
    @NotNull
    public ITcpServerFactory getTcpServerFactory() {
        return this.mTcpServerFactory;
    }

    @Override
    @NotNull
    public INameDb getNameDb() {
        return this.mNameDb;
    }

    @Override
    @NotNull
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }
}

