/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.web.protocol.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

public final class CRecordWebOpenNewTab
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"59a20942-af1b-43c1-ade6-e8a2f60e69aa");
    public static final String NAME = "WebOpenNewTab";
    public static final String DESCRIPTION = "Opens a new tab in the browser with this URL.";
    public static final String SLOT_PARAMETER = "3";
    public static final String SLOT_SAME_URL = "1";
    public static final String SLOT_URL = "2";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CStringProperties getParameter(@NotNull CRecord aRecord, CStringProperties aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PARAMETER);
        if (slot == null) {
            return aDefault;
        }
        return (CStringProperties)slot.getValue();
    }

    public static boolean getSameUrl(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SAME_URL);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static String getUrl(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_URL);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setParameter(@NotNull CRecord aRecord, CStringProperties aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_PROPERTIES, (Object)aValue);
        aRecord.addSlot(SLOT_PARAMETER, slot);
    }

    public static void setSameUrl(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_SAME_URL, slot);
    }

    public static void setUrl(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_URL, slot);
    }
}

