/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.nodeinfo.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordGetNodeInfo
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"3cbe588a-720b-4ac0-a5bc-34457583e322");
    public static final String NAME = "GetNodeInfo";
    public static final String DESCRIPTION = "Get information about a node.";
    public static final String SLOT_NODE = "1";
    public static final String SLOT_NODE_INFO = "10";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CNodeAddress getNode(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODE);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static CRecord getNodeInfo(@NotNull CRecord aRecord, CRecord aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODE_INFO);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord)slot.getValue();
    }

    public static void setNode(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_NODE, slot);
    }

    public static void setNodeInfo(@NotNull CRecord aRecord, CRecord aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD, (Object)aValue);
        aRecord.addSlot(SLOT_NODE_INFO, slot);
    }
}

