/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkNotifyConnectionClosed
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"d19f0223-fd82-4a15-ae05-294ec272390f");
    public static final String NAME = "NetworkNotifyConnectionClosed";
    public static final String DESCRIPTION = "Notification that a connection has been closed. Sender: from Connection indirectly via NanoService Receiver: ConnectionRegistry: Connection will be deregistered.";
    public static final String SLOT_CONNECTION = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CRecord getConnection(@NotNull CRecord aRecord, CRecord aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CONNECTION);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord)slot.getValue();
    }

    public static void setConnection(@NotNull CRecord aRecord, CRecord aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD, (Object)aValue);
        aRecord.addSlot(SLOT_CONNECTION, slot);
    }
}

