/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkRoutePacket
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"81a87d3a-a431-469f-8325-920761bed8fa");
    public static final String NAME = "NetworkRoutePacket";
    public static final String DESCRIPTION = "A message from CTransport to ConnectionRegistry will be forwarded to another CTransport. Route a packet to another transport because the message inside is for another node.";
    public static final String SLOT_DESTINATION_NODE = "1";
    public static final String SLOT_PACKET = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CNodeAddress getDestinationNode(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DESTINATION_NODE);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static Object getPacket(@NotNull CRecord aRecord, Object aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PACKET);
        if (slot == null) {
            return aDefault;
        }
        return slot.getValue();
    }

    public static void setDestinationNode(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_DESTINATION_NODE, slot);
    }

    public static void setPacket(@NotNull CRecord aRecord, Object aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.OBJECT, (Object)aValue);
        aRecord.addSlot(SLOT_PACKET, slot);
    }
}

