/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.session.api;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbUserRecord;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.time.CUtilLocalDateTime;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUser
implements Comparable<CUser> {
    private final String mCreatedByUser;
    private final LocalDateTime mTimeCreated;
    private String mId;
    private String mRealName;
    private String mEmail;
    private String mPicture;
    private String mPassword;

    public CUser(@NotNull String aId, @NotNull String aRealName, @NotNull String aEmail, @NotNull String aPicture, @NotNull String aCreatedByUser, @NotNull LocalDateTime aTimeCreated) {
        this.mId = aId;
        this.mRealName = aRealName;
        this.mEmail = aEmail;
        this.mPicture = aPicture;
        this.mCreatedByUser = aCreatedByUser;
        this.mTimeCreated = aTimeCreated;
    }

    public CUser() {
        this("", "", "", "", "", LocalDateTime.now());
    }

    public CUser(@NotNull String aId, @NotNull String aRealName, @NotNull String aEmail, @NotNull String aPicture) {
        this(aId, aRealName, aEmail, aPicture, "", LocalDateTime.now());
    }

    public CUser(@NotNull CUser aUser) {
        this(aUser.mId, aUser.mRealName, aUser.mEmail, aUser.mPicture, aUser.mCreatedByUser, aUser.mTimeCreated);
        this.mPassword = aUser.mPassword;
    }

    @Nullable
    public static CUser fromRecord(@NotNull CRecord aRecord) {
        if (CRecordUserDbUserRecord.ID.equals((Object)aRecord.getId())) {
            String userId = CRecordUserDbUserRecord.getUserId(aRecord, null);
            String email = CRecordUserDbUserRecord.getEmail(aRecord, "");
            String picture = CRecordUserDbUserRecord.getPicture(aRecord, "");
            String realName = CRecordUserDbUserRecord.getRealName(aRecord, "");
            String createdBy = CRecordUserDbUserRecord.getCreatedBy(aRecord, "");
            LocalDateTime timeCreated = CRecordUserDbUserRecord.getTimeCreated(aRecord, null);
            if (CUtilString.isValid((String)userId)) {
                return new CUser(userId, realName, email, picture, createdBy, timeCreated);
            }
        }
        return null;
    }

    @NotNull
    public static CUser fromStream(@NotNull DataInputStream aStream) throws IOException, CException {
        String id = CUtilString.fromStream((DataInput)aStream);
        CUtilCheck.checkEmptyStringEx((Object)id, (String)"missing id", (Object[])new Object[0]);
        assert (id != null);
        String realName = CUtilString.fromStream((DataInput)aStream);
        String email = CUtilString.fromStream((DataInput)aStream);
        String picture = CUtilString.fromStream((DataInput)aStream);
        String createdBy = CUtilString.fromStream((DataInput)aStream);
        LocalDateTime timestamp = CUtilLocalDateTime.fromStream((DataInput)aStream);
        return new CUser(id, realName == null ? "" : realName, email == null ? "" : email, picture == null ? "" : picture, createdBy == null ? "" : createdBy, timestamp == null ? LocalDateTime.now() : timestamp);
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String aPassword) {
        this.mPassword = aPassword;
    }

    @NotNull
    public String getId() {
        return this.mId;
    }

    public void setId(@NotNull String aId) {
        this.mId = aId;
    }

    @NotNull
    public String getRealName() {
        return this.mRealName;
    }

    public void setRealName(@NotNull String aRealName) {
        this.mRealName = aRealName;
    }

    @NotNull
    public String getEmail() {
        return this.mEmail;
    }

    public void setEmail(@NotNull String aEmail) {
        this.mEmail = aEmail;
    }

    @NotNull
    public String getPicture() {
        return this.mPicture;
    }

    public void setPicture(@NotNull String aPicture) {
        this.mPicture = aPicture;
    }

    @NotNull
    public String getCreatedByUser() {
        return this.mCreatedByUser;
    }

    @NotNull
    public LocalDateTime getTimeCreated() {
        return this.mTimeCreated;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CUser cUser = (CUser)aO;
        return this.mId.equals(cUser.mId);
    }

    public String toString() {
        return "User " + this.mId + ": RealName=" + this.mRealName + ", EMail=" + this.mEmail;
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    public void toStream(@NotNull DataOutputStream aStream) throws IOException {
        CUtilString.toStream((DataOutput)aStream, (String)this.mId);
        CUtilString.toStream((DataOutput)aStream, (String)this.mRealName);
        CUtilString.toStream((DataOutput)aStream, (String)this.mEmail);
        CUtilString.toStream((DataOutput)aStream, (String)this.mPicture);
        CUtilString.toStream((DataOutput)aStream, (String)this.mCreatedByUser);
        CUtilLocalDateTime.toStream((DataOutput)aStream, (LocalDateTime)this.mTimeCreated);
    }

    @NotNull
    public CRecord toRecord() throws CException {
        CRecord record = CRecordUserDbUserRecord.create();
        CRecordUserDbUserRecord.setUserId(record, this.mId);
        CRecordUserDbUserRecord.setRealName(record, this.mRealName);
        CRecordUserDbUserRecord.setEmail(record, this.mEmail);
        CRecordUserDbUserRecord.setPicture(record, this.mPicture);
        CRecordUserDbUserRecord.setCreatedBy(record, this.mCreatedByUser);
        CRecordUserDbUserRecord.setTimeCreated(record, this.mTimeCreated);
        return record;
    }

    @Override
    public int compareTo(@NotNull CUser aUser) {
        return this.mId.compareTo(aUser.mId);
    }
}

