/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address.util;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.address.util.CTargetAddressList;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CTargetAddressMap<T> {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetAddressList.class);
    private static int mNumber = 0;
    private final Map<CTargetAddress, T> mMap = new ConcurrentHashMap<CTargetAddress, T>();
    private final String mName;

    public CTargetAddressMap() {
        this.mName = Integer.toString(++mNumber);
    }

    public CTargetAddressMap(String aName) {
        this.mName = aName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(CTargetAddress aAddress) {
        Map<CTargetAddress, T> map = this.mMap;
        synchronized (map) {
            return this.mMap.containsKey(aAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(CTargetAddress aAddress) {
        Map<CTargetAddress, T> map = this.mMap;
        synchronized (map) {
            return this.mMap.get(aAddress);
        }
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CTargetAddress> keySet() {
        Map<CTargetAddress, T> map = this.mMap;
        synchronized (map) {
            return new ArrayList<CTargetAddress>(this.mMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T put(CTargetAddress aAddress, T aValue) {
        Map<CTargetAddress, T> map = this.mMap;
        synchronized (map) {
            return this.mMap.put(aAddress, aValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(CTargetAddress aAddress) {
        LOG.debug("Remove address {} from TargetAddressMap {}", aAddress, this.mName);
        Map<CTargetAddress, T> map = this.mMap;
        synchronized (map) {
            return this.mMap.remove(aAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNamespace(IId aNID, CNodeId aNodeId) {
        LOG.debug("Remove local Namespace {} from TargetAddressMap {}.", aNID, this.mName);
        Map<CTargetAddress, T> map = this.mMap;
        synchronized (map) {
            return this.mMap.entrySet().removeIf(e -> ((CTargetAddress)e.getKey()).getNID().equals(aNID) && ((CTargetAddress)e.getKey()).getNodeId().equals(aNodeId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNode(CNodeId aNodeId) {
        LOG.debug("Remove node {} from TargetAddressMap {}", aNodeId, this.mName);
        Map<CTargetAddress, T> map = this.mMap;
        synchronized (map) {
            return this.mMap.entrySet().removeIf(e -> ((CTargetAddress)e.getKey()).getNodeId().equals(aNodeId));
        }
    }

    public int size() {
        return this.mMap.size();
    }
}

