/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.converter.impl.converter;

import de.sillysky.nyssr.converter.IConverter;
import de.sillysky.nyssr.converter.IConverterRegistry;
import java.util.Map;

public final class CByteToString
implements IConverter<Byte, String> {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int LOW_NIBBLE = 15;
    private static final int HIGH_NIBBLE = 240;
    private static final int BITS_NIBBLE = 4;

    @Override
    public String convertTo(Byte aValue, Map<String, Object> aConstraints) {
        if (aValue == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(3);
        byte ch = (byte)(aValue & 0xF0);
        ch = (byte)(ch >> 4);
        ch = (byte)(ch & 0xF);
        sb.append(HEX_CHARS[ch]);
        ch = (byte)(aValue & 0xF);
        sb.append(HEX_CHARS[ch]);
        return sb.toString();
    }

    @Override
    public Class<?> getDestinationClass() {
        return String.class;
    }

    @Override
    public String getDestinationType() {
        return "";
    }

    @Override
    public Class<?> getSourceClass() {
        return Byte.class;
    }

    @Override
    public String getSourceType() {
        return "";
    }

    @Override
    public void setRegistry(IConverterRegistry aRegistry) {
    }
}

