/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.converter.impl.converter;

import de.sillysky.nyssr.converter.IConverter;
import de.sillysky.nyssr.converter.IConverterRegistry;
import de.sillysky.nyssr.converter.impl.converter.CUtilConverter;
import de.sillysky.nyssr.exception.CUtilCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class CStringToCollection
implements IConverter<String, Collection<String>> {
    @Override
    public Collection<String> convertTo(String aStr, Map<String, Object> aConstraints) {
        if (CUtilConverter.checkNull(aStr)) {
            return null;
        }
        CUtilCheck.checkTrue(aStr.startsWith("["), "Missing %s", "[");
        CUtilCheck.checkTrue(aStr.endsWith("]"), "Missing %s", "]");
        String v = aStr.substring(1, aStr.length() - 1);
        Collection<String> split1 = CUtilConverter.split(v);
        ArrayList<String> split2 = new ArrayList<String>();
        for (String s : split1) {
            if (CUtilConverter.checkNull(s)) {
                split2.add(null);
                continue;
            }
            split2.add(s);
        }
        return split2;
    }

    @Override
    public Class<?> getDestinationClass() {
        return Collection.class;
    }

    @Override
    public String getDestinationType() {
        return "";
    }

    @Override
    public Class<?> getSourceClass() {
        return String.class;
    }

    @Override
    public String getSourceType() {
        return "";
    }

    @Override
    public void setRegistry(IConverterRegistry aRegistry) {
    }
}

