/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.converter.impl.converter;

import de.sillysky.nyssr.converter.IConverter;
import de.sillysky.nyssr.converter.IConverterRegistry;
import de.sillysky.nyssr.converter.impl.converter.CUtilConverter;
import de.sillysky.nyssr.exception.CUtilCheck;
import java.util.Collection;
import java.util.Map;

public final class CStringToStringArray
implements IConverter<String, String[]> {
    @Override
    public String[] convertTo(String aStr, Map<String, Object> aConstraints) {
        if (CUtilConverter.checkNull(aStr)) {
            return null;
        }
        CUtilCheck.checkTrue(aStr.startsWith("["), "Missing %s", "[");
        CUtilCheck.checkTrue(aStr.endsWith("]"), "Missing %s", "]");
        String v = aStr.substring(1, aStr.length() - 1);
        Collection<String> split = CUtilConverter.split(v);
        String[] arr = new String[split.size()];
        int i = 0;
        for (String s : split) {
            if (CUtilConverter.checkNull(s)) {
                arr[i++] = null;
                continue;
            }
            arr[i++] = s;
        }
        return arr;
    }

    @Override
    public Class<?> getDestinationClass() {
        return String[].class;
    }

    @Override
    public String getDestinationType() {
        return "";
    }

    @Override
    public Class<?> getSourceClass() {
        return String.class;
    }

    @Override
    public String getSourceType() {
        return "";
    }

    @Override
    public void setRegistry(IConverterRegistry aRegistry) {
    }
}

