/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.cli;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.impl.cli.CCommandEntry;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

class CHandlerList {
    private final Map<String, CCommandEntry> mHandlers = new ConcurrentHashMap<String, CCommandEntry>();

    CHandlerList() {
    }

    void addHandler(@NotNull String aCommand, @NotNull String aHelp, @NotNull CTargetAddress aHandler) {
        this.mHandlers.put(aCommand, new CCommandEntry(aCommand, aHelp, aHandler));
    }

    void removeHandler(@NotNull CTargetAddress aHandler) {
        this.mHandlers.values().removeIf(h -> h.getAddress() == aHandler);
    }

    void removeHandler(@NotNull String aCommand, @NotNull CTargetAddress aHandler) {
        CCommandEntry entry = this.mHandlers.get(aCommand);
        if (entry != null && entry.getAddress().equals(aHandler)) {
            this.mHandlers.remove(aCommand);
        }
    }

    CCommandEntry get(@NotNull String aCommand) {
        return this.mHandlers.get(aCommand);
    }

    Iterator<CCommandEntry> iterator() {
        TreeSet<CCommandEntry> tree = new TreeSet<CCommandEntry>(this.mHandlers.values());
        return tree.iterator();
    }

    int size() {
        return this.mHandlers.size();
    }
}

