/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.log.catcher;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.log.catcher.CCatcherLogWriter;
import de.sillysky.nyssr.impl.log.catcher.CUtilLog;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLogDto;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ELevel;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.log.catcher.ILogCatcher;
import de.sillysky.nyssr.log.catcher.records.CRecordNotifyLogCaught;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.EPriority;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

final class CLogCatcher
implements ILogCatcher,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CLogCatcher.class);
    private static final String[] IGNORE_LOGGER = new String[]{"connection.protocol", "connection.packet", "connection.bytes", "sensitive", "onlylocal", "record.from.stream"};
    private final List<CLogDto> mEvents = new ArrayList<CLogDto>();
    private final UUID mId = CUtilUuid.random();
    private boolean mHookStarted = false;
    private CCatcherLogWriter mLogWriter = null;
    private int mMaximumSavedLogs = 10000;
    private IListenerRegistry mListenerRegistry;
    private CTargetAddress mMyAddress;
    private IMessageSender mMessageSender;

    CLogCatcher() {
    }

    static void addDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(IListenerRegistry.class);
        aDependencyList.add(IMessageSender.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        IKernelConfiguration kernelConfiguration = aServiceRegistry.getService(IKernelConfiguration.class);
        assert (kernelConfiguration != null);
        Preferences prefs = kernelConfiguration.getPreferences("logging/catcher");
        this.mMaximumSavedLogs = prefs.getInt("max.number.of.saved.log.entries", 10000);
        this.mListenerRegistry = aServiceRegistry.getService(IListenerRegistry.class);
        this.mMessageSender = aServiceRegistry.getService(IMessageSender.class);
        this.mMyAddress = new CTargetAddress(CWellKnownTID.LOG_CATCHER, CWellKnownNID.MONITOR, kernelConfiguration.getNodeAddress());
        this.start();
        aServiceRegistry.registerService(ILogCatcher.class, this);
    }

    @Override
    public void addListener(@NotNull CTargetAddress aListener) {
        this.mListenerRegistry.addAddress(this.mId, aListener);
        try {
            this.sendPendingMessages(aListener);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Error sending pending logs");
        }
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.stop();
        aServiceRegistry.deregisterService(this);
    }

    @Override
    public Map<String, ELevel> getLoggerLevels() {
        return this.mLogWriter.getLoggerLevels();
    }

    @Override
    public ELevel getRootLevel() {
        return this.mLogWriter.getRootLevel();
    }

    private void informListeners(@NotNull CLogDto aDto) throws CException {
        CEnvelope env = new CEnvelope();
        env.setSender(this.mMyAddress);
        env.setLogEnabled(false);
        env.setPriority(EPriority.LOW);
        String loggerName = aDto.getLoggerName();
        boolean isAllowed = this.privateIsLoggerAllowed(loggerName);
        if (!isAllowed) {
            env.setOnlyLocal(true);
        }
        CRecord rec = CUtilLog.dtoToRecord(aDto);
        CRecord record = CRecordNotifyLogCaught.create();
        CRecordNotifyLogCaught.setLogRecords(record, new CRecord[]{rec});
        CMessage msg = new CMessage(env, record);
        this.mListenerRegistry.sendNotification(this.mId, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyLog(@NotNull CLogDto aDto) throws CException {
        int count = this.mListenerRegistry.getNumberOfListener(this.mId);
        if (count > 0) {
            this.informListeners(aDto);
        } else {
            List<CLogDto> list = this.mEvents;
            synchronized (list) {
                this.mEvents.add(aDto);
            }
        }
    }

    private boolean privateIsLoggerAllowed(@NotNull String aLogger) {
        for (String logger : IGNORE_LOGGER) {
            if (!logger.equals(aLogger)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeListener(@NotNull CTargetAddress aListener) {
        this.mListenerRegistry.removeAddress(this.mId, aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPendingMessages(CTargetAddress aAddress) throws CException {
        int size;
        List<CLogDto> list = this.mEvents;
        synchronized (list) {
            size = this.mEvents.size();
        }
        while (size > 0) {
            CRecord[] arr;
            List<CLogDto> list2 = this.mEvents;
            synchronized (list2) {
                int amount = Math.min(100, this.mEvents.size());
                arr = new CRecord[amount];
                for (int i = 0; i < amount; ++i) {
                    CLogDto dto = this.mEvents.remove(0);
                    arr[i] = CUtilLog.dtoToRecord(dto);
                }
            }
            CEnvelope env = CEnvelope.forSingleTarget(aAddress);
            CRecord record = CRecordNotifyLogCaught.create();
            CRecordNotifyLogCaught.setLogRecords(record, arr);
            this.mMessageSender.sendNotification(env, record);
            List<CLogDto> list3 = this.mEvents;
            synchronized (list3) {
                size = this.mEvents.size();
            }
        }
    }

    @Override
    public void setLoggerLevel(@NotNull String aName, @NotNull ELevel aLevel) {
        this.mLogWriter.setLevel(aName, aLevel);
        CLoggerFactory.getConfiguration().update();
    }

    @Override
    public void start() {
        this.mMaximumSavedLogs = Math.max(0, this.mMaximumSavedLogs);
        if (!this.mHookStarted) {
            this.mHookStarted = true;
            this.mLogWriter = new CCatcherLogWriter(this);
            CLoggerFactory.getConfiguration().addWriter(this.mLogWriter);
            CLoggerFactory.getConfiguration().update();
        }
    }

    @Override
    public void stop() {
        if (this.mHookStarted) {
            this.mHookStarted = false;
            CLoggerFactory.getConfiguration().removeWriter(this.mLogWriter);
            CLoggerFactory.getConfiguration().update();
        }
    }
}

