/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.queue;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.message.queue.CAsyncMessageQueue;
import de.sillysky.nyssr.impl.message.queue.CSyncMessageQueue;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.IPostMan;
import de.sillysky.nyssr.message.queue.IMessageQueue;
import de.sillysky.nyssr.message.queue.IMessageQueueRegistry;
import de.sillysky.nyssr.message.queue.records.CRecordGetQueueInfo;
import de.sillysky.nyssr.message.queue.records.CRecordNotifyQueueDeregistered;
import de.sillysky.nyssr.message.queue.records.CRecordNotifyQueueRegistered;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CMessageQueueRegistry
implements IMessageQueueRegistry {
    private static final UUID LISTENER_ID = UUID.randomUUID();
    private static final ILogger LOG = CLoggerFactory.getLogger(CMessageQueueRegistry.class);
    private final IId mNID;
    private final IPostMan mPostMan;
    private final IMessageSender mMessageSender;
    private final IListenerRegistry mListenerRegistry;
    private final Map<IId, IMessageQueue> mQueues = new ConcurrentHashMap<IId, IMessageQueue>(10);
    private IMessageQueue mFirstQueue = null;

    CMessageQueueRegistry(IId aNID, IPostMan aCaller, IMessageSender aMessageSender, IListenerRegistry aListenerRegistry) {
        this.mNID = aNID;
        this.mPostMan = aCaller;
        this.mMessageSender = aMessageSender;
        this.mListenerRegistry = aListenerRegistry;
    }

    @Override
    @NotNull
    public IMessageQueue createAndStartAsyncQueue(@NotNull IId aQueueId, @NotNull String aDesc, int aThreadPriority) throws CException {
        if (aDesc.isEmpty()) {
            throw new CException(7).append("Namespace ").append(this.mNID).append(": Cannot create queue without name.");
        }
        int priority = aThreadPriority;
        if (priority < 1) {
            priority = 1;
        } else if (priority > 10) {
            priority = 10;
        }
        LOG.info("Start creating async queue {} in namespace {}, priority={}.", aDesc, this.mNID, priority);
        CAsyncMessageQueue q = new CAsyncMessageQueue(this, this.mMessageSender, aQueueId, aDesc, this.mPostMan, aThreadPriority);
        this.register(q);
        q.start();
        return q;
    }

    @Override
    public void deactivate() {
        Iterator<IId> it = this.mQueues.keySet().iterator();
        while (it.hasNext()) {
            IId queueId = it.next();
            IMessageQueue queue = this.mQueues.get(queueId);
            queue.dismiss();
            it.remove();
        }
        this.mFirstQueue = null;
    }

    @Override
    public void deleteQueue(@NotNull IId aQueueId) throws CException {
        if (!aQueueId.isValid()) {
            throw new CException(2402).append("Can't find the queue <").append(aQueueId).append("> for deregister it.");
        }
        IMessageQueue queue = this.remove(aQueueId);
        if (queue == null) {
            throw new CException(2401).append("Can't find the queue <").append(aQueueId).append("> for deregister it.");
        }
        queue.dismiss();
        LOG.info("    Namespace <{}>: Delete queue <{}>.", this.mNID, aQueueId);
        this.triggerObserver(queue, CRecordNotifyQueueDeregistered.ID);
    }

    @Override
    public void deregisterQueueObserver(@NotNull CTargetAddress aListener) {
        boolean removed = this.mListenerRegistry.removeAddress(LISTENER_ID, aListener);
        if (removed) {
            LOG.info("Namespace {}: QueueListener removed: {}.", this.mNID, aListener);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CMessageQueueRegistry other = (CMessageQueueRegistry)obj;
        return this.mNID.equals(other.mNID);
    }

    @Override
    public IMessageQueue getFirstQueue() {
        return this.mFirstQueue;
    }

    @Override
    @NotNull
    public IId getNamespaceId() {
        return this.mNID;
    }

    @Override
    public IMessageQueue getQueue(@NotNull IId aQueueId) {
        IMessageQueue queue = this.mQueues.get(aQueueId);
        if (queue == null) {
            LOG.debug("Warning: queue {} is unknown.", aQueueId);
        }
        return queue;
    }

    @Override
    @NotNull
    public IMessageQueue getQueueEx(@NotNull IId aQID) throws CException {
        IMessageQueue queue = this.mQueues.get(aQID);
        if (queue == null) {
            throw new CException(2401).append("Queue <" + String.valueOf(aQID) + "> unknown.");
        }
        return queue;
    }

    @Override
    public IId @NotNull [] getQueueIdArray() {
        int size = this.mQueues.size();
        IId[] arr = new IId[size];
        if (size > 0) {
            Iterator<IId> it = this.mQueues.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                arr[i++] = it.next();
            }
        }
        return arr;
    }

    @Override
    public void getQueueInfo(@NotNull IId aQueueId, @NotNull CRecord aRecord) throws CException {
        IMessageQueue queue = this.mQueues.get(aQueueId);
        if (queue != null) {
            CRecordGetQueueInfo.setQid(aRecord, aQueueId);
            CRecordGetQueueInfo.setExist(aRecord, true);
            boolean isSync = queue instanceof CSyncMessageQueue;
            CRecordGetQueueInfo.setIsSync(aRecord, isSync);
            int size = queue.getSize();
            CRecordGetQueueInfo.setTargetCount(aRecord, size);
            String threadName = queue.getThread().getName();
            CRecordGetQueueInfo.setThreadName(aRecord, threadName);
            int priority = queue.getThread().getPriority();
            CRecordGetQueueInfo.setThreadPriority(aRecord, priority);
        } else {
            CRecordGetQueueInfo.setExist(aRecord, false);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mNID.hashCode();
        return result;
    }

    @Contract(value="null -> fail")
    @NotNull
    private IId register(@Nullable IMessageQueue aQueue) throws CException {
        if (aQueue == null) {
            throw new CException(7).append("Can't register a null queue.");
        }
        IId queueId = aQueue.getId();
        this.mQueues.put(queueId, aQueue);
        if (this.mFirstQueue == null) {
            this.mFirstQueue = aQueue;
        }
        LOG.info("Okay: Queue {} registered.", queueId);
        this.triggerObserver(aQueue, CRecordNotifyQueueRegistered.ID);
        return queueId;
    }

    @Override
    public IId @NotNull [] registerQueueObserver(@NotNull CTargetAddress aListener) {
        boolean added = this.mListenerRegistry.addAddress(LISTENER_ID, aListener);
        if (added) {
            LOG.info("Okay: Queue listener {} added to namespace {}.", aListener, this.mNID);
            return this.getQueueIdArray();
        }
        return new IId[0];
    }

    @Override
    public int size() {
        return this.mQueues.size();
    }

    private IMessageQueue remove(@NotNull IId aQueueId) {
        IMessageQueue mq = this.mQueues.remove(aQueueId);
        if (mq == this.mFirstQueue) {
            this.mFirstQueue = null;
            if (!this.mQueues.isEmpty()) {
                Iterator<IMessageQueue> it = this.mQueues.values().iterator();
                this.mFirstQueue = it.next();
            }
        }
        return mq;
    }

    private void triggerObserver(@NotNull IMessageQueue aQueue, @NotNull IId aNotificationId) throws CException {
        if (this.mListenerRegistry.getNumberOfListener(LISTENER_ID) > 0) {
            CRecord rec = null;
            if (CRecordNotifyQueueRegistered.ID.equals(aNotificationId)) {
                rec = new CRecord(aNotificationId);
                CRecordNotifyQueueRegistered.setQueueId(rec, aQueue.getId());
            } else if (CRecordNotifyQueueDeregistered.ID.equals(aNotificationId)) {
                rec = new CRecord(aNotificationId);
                CRecordNotifyQueueDeregistered.setQueueId(rec, aQueue.getId());
            }
            if (rec != null) {
                CMessage msg = new CMessage(new CEnvelope(), rec);
                this.mListenerRegistry.sendNotification(LISTENER_ID, msg);
            }
        }
    }
}

