/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.helper;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRecordHelperService
implements IRecordHelper,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRecordHelperService.class);
    private INamespaceRegistry mNamespaceRegistry;

    public static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceRegistry.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mNamespaceRegistry = aServiceRegistry.getService(INamespaceRegistry.class);
        aServiceRegistry.registerService(IRecordHelper.class, this);
    }

    @Override
    public boolean addObserver(@NotNull Class<?> aClass, @NotNull ITarget aTarget, boolean aSendLast) throws CException {
        CUtilCheck.checkNotNull(aTarget, "Target missing", new Object[0]);
        CTargetAddress address = aTarget.getAddress();
        CUtilCheck.checkTrue(address.isValid(), "Target not registered yet", new Object[0]);
        IId id = this.getID(aClass);
        String[] namespaces = this.getNamespaces(aClass);
        INamespace ns = this.getNamespace(aTarget, namespaces);
        if (ns != null) {
            try {
                ns.getNanoServiceRegistry().addObserver(id, address, aSendLast);
                return true;
            }
            catch (CException e) {
                LOG.error(e, "Couldn't add observer for NanoService {}.", id);
            }
        }
        return false;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    private IId getID(Class<?> aClass) throws CException {
        try {
            Field f1 = aClass.getDeclaredField("ID");
            CUtilCheck.checkNotNull(f1, "Class has no field ID", new Object[0]);
            IId id = (IId)f1.get(null);
            CUtilCheck.checkNotNull(id, "Class ID is null", new Object[0]);
            return id;
        }
        catch (Exception e) {
            throw new CException(e);
        }
    }

    @Override
    public IId getNID(@NotNull Class<?> aClass) throws CException {
        String[] namespaces = this.getNamespaces(aClass);
        return CIdFactory.fromObject(namespaces[0]);
    }

    @Override
    @Nullable
    public IId getNID(@NotNull Class<?> aClass, @NotNull ITarget aTarget) throws CException {
        String[] namespaces = this.getNamespaces(aClass);
        return this.getNID(aTarget, namespaces);
    }

    @Nullable
    private IId getNID(@Nullable ITarget aTarget, String @NotNull [] aNamespaces) {
        String choice;
        if (aNamespaces.length == 0) {
            return null;
        }
        if (aTarget == null) {
            choice = aNamespaces.length == 1 ? ("*".equals(aNamespaces[0]) ? CWellKnownNID.SYSTEM.toString() : aNamespaces[0]) : aNamespaces[0];
        } else if (aNamespaces.length == 1) {
            if ("*".equals(aNamespaces[0])) {
                return aTarget.getAddress().getNID();
            }
            choice = aNamespaces[0];
        } else {
            String targetNs;
            List<String> list = Arrays.asList(aNamespaces);
            if (list.contains(targetNs = aTarget.getAddress().getNID().valueToString())) {
                return aTarget.getAddress().getNID();
            }
            choice = aNamespaces[0];
        }
        return CIdFactory.fromObject(choice);
    }

    private String getName(Class<?> aClass) throws CException {
        try {
            Field f1 = aClass.getDeclaredField("NAME");
            CUtilCheck.checkNotNull(f1, "Class has no field NAME", new Object[0]);
            String name = (String)f1.get(null);
            CUtilCheck.checkNotNull(name, "Class NAME is null", new Object[0]);
            return name;
        }
        catch (Exception e) {
            throw new CException(e);
        }
    }

    public INamespace getNamespace(Class<?> aClass, ITarget aTarget) throws CException {
        String[] namespaces = this.getNamespaces(aClass);
        return this.getNamespace(aTarget, namespaces);
    }

    private INamespace getNamespace(ITarget aTarget, String[] aNamespaces) {
        IId nid = this.getNID(aTarget, aNamespaces);
        if (nid != null && this.mNamespaceRegistry != null) {
            return this.mNamespaceRegistry.getNamespace(nid);
        }
        return null;
    }

    private String[] getNamespaces(Class<?> aClass) throws CException {
        try {
            Field f2 = aClass.getDeclaredField("NAMESPACES");
            CUtilCheck.checkNotNull(f2, "Class has no field NAMESPACES", new Object[0]);
            String[] namespaces = (String[])f2.get(null);
            CUtilCheck.checkTrue(namespaces != null && namespaces.length > 0, "Namespaces for Service %s are empty", aClass.getSimpleName());
            return namespaces;
        }
        catch (Exception e) {
            throw new CException(e);
        }
    }

    public void init(INamespaceRegistry aNamespaceRegistry) {
        this.mNamespaceRegistry = aNamespaceRegistry;
    }

    @Override
    public boolean registerServiceAndAddObserver(@NotNull Class<?> aClass, @NotNull ITarget aTarget, @NotNull INamespace aNamespace, boolean aSendLast) throws CException {
        IId id = this.getID(aClass);
        String name = this.getName(aClass);
        try {
            INanoServiceRegistry sr = aNamespace.getNanoServiceRegistry();
            sr.addNanoService(id, name);
            sr.addObserver(id, aTarget.getAddress(), aSendLast);
            return true;
        }
        catch (CException e) {
            LOG.error(e, "Couldn't register NanoService {}.", id);
            return false;
        }
    }

    @Override
    public boolean removeObserver(@NotNull Class<?> aClass, @NotNull ITarget aTarget) throws CException {
        IId id = this.getID(aClass);
        String[] namespaces = this.getNamespaces(aClass);
        return this.removeObserver(aTarget, namespaces, id);
    }

    private boolean removeObserver(ITarget aTarget, String[] aNamespaces, IId aID) {
        if (aNamespaces == null || aNamespaces.length == 0) {
            LOG.error("Namespaces for Service {} are empty, can't remove observer for target {}", aID, aTarget.getClass().getName());
            return false;
        }
        INamespace ns = this.getNamespace(aTarget, aNamespaces);
        if (ns != null) {
            try {
                ns.getNanoServiceRegistry().removeObserver(aID, aTarget.getAddress());
                return true;
            }
            catch (CException e) {
                LOG.error(e, "Couldn't remove observer for NanoService {}.", aID);
            }
        }
        return false;
    }
}

