/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.service;

import de.sillysky.nyssr.impl.service.IThreadPoolManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public class CTestThreadPoolManager
implements IThreadPoolManager {
    private final List<Runnable> mRunnables = new CopyOnWriteArrayList<Runnable>();
    private Runnable mCurrentRunnable;
    private boolean mStopped = false;

    @Override
    public void submitJob(@NotNull Runnable aJob) {
        if (!this.mStopped) {
            this.mRunnables.add(aJob);
            this.run();
        }
    }

    private void run() {
        if (this.mCurrentRunnable == null) {
            while (!this.mRunnables.isEmpty()) {
                this.mCurrentRunnable = this.mRunnables.remove(0);
                this.mCurrentRunnable.run();
                this.mCurrentRunnable = null;
            }
        }
    }

    @Override
    public void shutdown() {
        this.mStopped = true;
        this.mRunnables.clear();
        this.mCurrentRunnable = null;
    }

    @Override
    public void reset() {
        this.mRunnables.clear();
        this.mCurrentRunnable = null;
    }
}

