/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilBoolean;
import de.sillysky.nyssr.util.CUtilBooleanArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotBooleanArray
implements ISlot,
ISingleSlotTypeFactory {
    private final boolean[] mValue;

    CSlotBooleanArray() {
        this.mValue = null;
    }

    private CSlotBooleanArray(boolean[] aValue) {
        this.mValue = CUtilBooleanArray.copy(aValue);
    }

    @NotNull
    private static CSlotBooleanArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof boolean[]) {
            return new CSlotBooleanArray((boolean[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotBooleanArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotBooleanArray.fromList((List)aValue);
        }
        return new CSlotBooleanArray();
    }

    @NotNull
    private static CSlotBooleanArray fromList(@NotNull List<?> aValue) {
        boolean[] arr = CUtilBooleanArray.fromList(aValue);
        return new CSlotBooleanArray(arr);
    }

    @NotNull
    private static CSlotBooleanArray fromStream(@NotNull DataInput aStream) throws IOException {
        boolean[] value = CUtilBooleanArray.fromStream(aStream);
        return new CSlotBooleanArray(value);
    }

    @NotNull
    private static CSlotBooleanArray fromString(@NotNull String aValue) {
        boolean[] value = CUtilBooleanArray.fromString(aValue);
        return new CSlotBooleanArray(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotBooleanArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            boolean[] values = new boolean[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                boolean j;
                values[i] = j = CUtilBoolean.fromObject(child, false);
                ++i;
            }
            return new CSlotBooleanArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotBooleanArray other = (CSlotBooleanArray)aObj;
        return CUtilBooleanArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return boolean[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        boolean[] value = CUtilBooleanArray.copy(this.mValue);
        return new CSlotBooleanArray(value);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.BOOLEAN_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof boolean[]) {
            boolean[] bb = (boolean[])aValue;
            return CUtilBooleanArray.isEqual(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotBooleanArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilBooleanArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilBooleanArray.toString(this.mValue, ',', 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilBooleanArray.toString(this.mValue, ',', 0);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (boolean i : this.mValue) {
                arr.add(i);
            }
            return arr;
        }
        return null;
    }
}

