/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilByte;
import de.sillysky.nyssr.util.CUtilInteger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotByte
implements ISlot,
ISingleSlotTypeFactory {
    @NotNull
    private final Byte mValue;

    CSlotByte() {
        this.mValue = 0;
    }

    private CSlotByte(byte aValue) {
        this.mValue = aValue;
    }

    private CSlotByte(@Nullable Byte aValue) {
        this.mValue = aValue == null ? Byte.valueOf((byte)0) : aValue;
    }

    @NotNull
    private static CSlotByte fromObject(@Nullable Object aValue) {
        if (aValue instanceof Byte) {
            return new CSlotByte((Byte)aValue);
        }
        if (aValue instanceof String) {
            return CSlotByte.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotByte.fromList((List)aValue);
        }
        return new CSlotByte();
    }

    @NotNull
    private static CSlotByte fromList(@NotNull List<?> aValue) {
        if (aValue.isEmpty()) {
            return new CSlotByte();
        }
        Object object = aValue.get(0);
        return CSlotByte.fromObject(object);
    }

    @NotNull
    private static CSlotByte fromStream(@NotNull DataInput aStream) throws IOException {
        byte value = aStream.readByte();
        return new CSlotByte(value);
    }

    @NotNull
    private static CSlotByte fromString(@NotNull String aValue) {
        byte value = CUtilByte.fromObject(aValue, (byte)0);
        return new CSlotByte(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotByte.fromObject(aValue);
        }
        return null;
    }

    @Override
    @NotNull
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        int value = CUtilInteger.fromObject(aValue, 0);
        return new CSlotByte((byte)value);
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotByte other = (CSlotByte)aObj;
        return this.mValue.equals(other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Byte.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.BYTE;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return this.mValue.hashCode();
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return this.mValue.equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotByte.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        aStream.writeByte(this.mValue.byteValue());
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return Byte.toString(this.mValue);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilByte.toString(this.mValue);
    }

    @Override
    @NotNull
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return (int)this.mValue.byteValue();
    }
}

