/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilDouble;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotDouble
implements ISlot,
ISingleSlotTypeFactory {
    @NotNull
    private final Double mValue;

    CSlotDouble() {
        this.mValue = 0.0;
    }

    private CSlotDouble(double aValue) {
        this.mValue = aValue;
    }

    private CSlotDouble(@Nullable Double aValue) {
        this.mValue = aValue == null ? Double.valueOf(0.0) : aValue;
    }

    @NotNull
    private static CSlotDouble fromObject(@Nullable Object aValue) {
        if (aValue instanceof Double) {
            return new CSlotDouble((Double)aValue);
        }
        if (aValue instanceof String) {
            return CSlotDouble.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotDouble.fromList((List)aValue);
        }
        return new CSlotDouble();
    }

    @NotNull
    private static CSlotDouble fromList(@NotNull List<?> aValue) {
        CSlotDouble result;
        if (aValue.isEmpty()) {
            result = new CSlotDouble();
        } else {
            Object object = aValue.get(0);
            result = CSlotDouble.fromObject(object);
        }
        return result;
    }

    @NotNull
    private static CSlotDouble fromStream(@NotNull DataInput aStream) throws IOException {
        double value = aStream.readDouble();
        return new CSlotDouble(value);
    }

    @NotNull
    private static CSlotDouble fromString(@NotNull String aValue) {
        double value = CUtilDouble.fromString(aValue);
        return new CSlotDouble(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotDouble.fromObject(aValue);
        }
        return null;
    }

    @Override
    @NotNull
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        double value = CUtilDouble.fromObject(aValue, 0.0);
        return new CSlotDouble(value);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSlotDouble other = (CSlotDouble)obj;
        return Double.doubleToLongBits(this.mValue) == Double.doubleToLongBits(other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Double.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.DOUBLE;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return this.mValue.hashCode();
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return this.mValue.equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotDouble.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        aStream.writeDouble(this.mValue);
    }

    @NotNull
    public String toString() {
        return Double.toString(this.mValue);
    }

    @Override
    @NotNull
    public String valueToString() {
        return Double.toString(this.mValue);
    }

    @Override
    @NotNull
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return this.mValue;
    }
}

