/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilDouble;
import de.sillysky.nyssr.util.CUtilDoubleArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotDoubleArray
implements ISlot,
ISingleSlotTypeFactory {
    private final double[] mValue;

    CSlotDoubleArray() {
        this.mValue = null;
    }

    private CSlotDoubleArray(double @Nullable [] aValue) {
        this.mValue = CUtilDoubleArray.copy(aValue);
    }

    @NotNull
    private static CSlotDoubleArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof double[]) {
            return new CSlotDoubleArray((double[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotDoubleArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotDoubleArray.fromList((List)aValue);
        }
        return new CSlotDoubleArray();
    }

    @NotNull
    private static CSlotDoubleArray fromList(@NotNull List<?> aList) {
        double[] array = CUtilDoubleArray.fromList(aList);
        return new CSlotDoubleArray(array);
    }

    @NotNull
    private static CSlotDoubleArray fromStream(@NotNull DataInput aStream) throws IOException {
        double[] array = CUtilDoubleArray.fromStream(aStream);
        return new CSlotDoubleArray(array);
    }

    @NotNull
    private static CSlotDoubleArray fromString(@Nullable String aValue) {
        double[] value = CUtilDoubleArray.fromString(aValue);
        return new CSlotDoubleArray(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotDoubleArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            double[] values = new double[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                double j;
                values[i] = j = CUtilDouble.fromObject(child, 0.0);
                ++i;
            }
            return new CSlotDoubleArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotDoubleArray other = (CSlotDoubleArray)aObj;
        return CUtilDoubleArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return double[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        double[] value = CUtilDoubleArray.copy(this.mValue);
        return new CSlotDoubleArray(value);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.DOUBLE_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof double[]) {
            double[] bb = (double[])aValue;
            return CUtilDoubleArray.isEqual(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotDoubleArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilDoubleArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilDoubleArray.toString(this.mValue, ',', 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilDoubleArray.toString(this.mValue, ',', 0);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (double i : this.mValue) {
                arr.add(i);
            }
            return arr;
        }
        return null;
    }
}

