/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilInteger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotInt
implements ISlot,
ISingleSlotTypeFactory {
    private final int mValue;

    CSlotInt() {
        this.mValue = 0;
    }

    private CSlotInt(int aValue) {
        this.mValue = aValue;
    }

    private CSlotInt(@NotNull Integer aValue) {
        this.mValue = aValue;
    }

    @NotNull
    private static CSlotInt create(@Nullable Object aValue) {
        if (aValue instanceof Integer) {
            return new CSlotInt((int)((Integer)aValue));
        }
        if (aValue instanceof String) {
            return CSlotInt.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotInt.fromList((List)aValue);
        }
        return new CSlotInt();
    }

    @NotNull
    private static CSlotInt fromList(@NotNull List<?> aValue) {
        CSlotInt result;
        if (aValue.isEmpty()) {
            result = new CSlotInt();
        } else {
            Object object = aValue.get(0);
            result = CSlotInt.create(object);
        }
        return result;
    }

    @NotNull
    private static CSlotInt fromStream(@NotNull DataInput aStream) throws IOException {
        int value = aStream.readInt();
        return new CSlotInt(value);
    }

    @NotNull
    private static CSlotInt fromString(@NotNull String aValue) {
        int value = CUtilInteger.fromString(aValue);
        return new CSlotInt(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotInt.create(aValue);
        }
        return null;
    }

    @Override
    @NotNull
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        int i = CUtilInteger.fromObject(aValue, 0);
        return new CSlotInt(i);
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotInt other = (CSlotInt)aObj;
        return this.mValue == other.mValue;
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Integer.class;
    }

    @Override
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.INT;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return Integer.valueOf(this.mValue).equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotInt.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        aStream.writeInt(this.mValue);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public String toString() {
        return Integer.toString(this.mValue);
    }

    @Override
    @Contract(value=" -> new", pure=true)
    @NotNull
    public String valueToString() {
        return Integer.toString(this.mValue);
    }

    @Override
    @NotNull
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return this.mValue;
    }
}

