/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotNodeId
implements ISlot,
ISingleSlotTypeFactory {
    @Nullable
    private final CNodeId mValue;

    CSlotNodeId() {
        this.mValue = null;
    }

    private CSlotNodeId(@Nullable CNodeId aValue) {
        this.mValue = aValue;
    }

    @NotNull
    private static CSlotNodeId create(@Nullable Object aValue) {
        if (aValue instanceof CNodeId) {
            return new CSlotNodeId((CNodeId)aValue);
        }
        if (aValue instanceof String) {
            return CSlotNodeId.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotNodeId.fromList((List)aValue);
        }
        return new CSlotNodeId();
    }

    @NotNull
    private static CSlotNodeId fromList(@NotNull List<?> aValue) {
        CSlotNodeId result;
        if (aValue.isEmpty()) {
            result = new CSlotNodeId();
        } else {
            Object object = aValue.get(0);
            result = CSlotNodeId.create(object);
        }
        return result;
    }

    @NotNull
    private static CSlotNodeId fromStream(@NotNull DataInput aStream) throws IOException {
        CNodeId value = CNodeId.fromStream(aStream);
        return new CSlotNodeId(value);
    }

    @NotNull
    private static CSlotNodeId fromString(@NotNull String aValue) {
        CNodeId value = CNodeId.fromObject(aValue);
        return new CSlotNodeId(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotNodeId.create(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof String) {
            CNodeId nodeId = CNodeId.fromObject(aValue);
            return new CSlotNodeId(nodeId);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CSlotNodeId that = (CSlotNodeId)aOther;
        return Objects.equals(this.mValue, that.mValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return CNodeId.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return new CSlotNodeId(this.mValue);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.NODE_ID;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == null) {
            return aValue == null;
        }
        return this.mValue.equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotNodeId.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CNodeId.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CNodeId.toString(this.mValue);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CNodeId.valueToString(this.mValue);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null) {
            return this.mValue.valueToString();
        }
        return null;
    }
}

