/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.timer;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.timer.CTimerManager;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.timer.records.CRecordTimer;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

final class CTimerEntry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTimerEntry.class);
    private static final AtomicLong mNextHandle = new AtomicLong();
    private final long mHandle;
    private final IId mMessageID;
    private final CTargetAddress mReceiver;
    private final CRecord mRecord;
    private final boolean mRepeat;
    private final long mTimeout;
    private final CTimerManager mTimerService;
    private long mLastTime;
    private long mCounter = 1L;

    CTimerEntry(CTimerManager aTimerService, CTargetAddress aReceiver, IId aMessageID, long aTimeout, boolean aRepeat, CRecord aRecord) {
        this.mTimerService = aTimerService;
        this.mReceiver = aReceiver;
        this.mMessageID = aMessageID;
        this.mTimeout = aTimeout;
        this.mRepeat = aRepeat;
        this.mLastTime = CTimerManager.tick();
        this.mRecord = aRecord;
        this.mHandle = mNextHandle.incrementAndGet();
        LOG.debug("Start Timer: ID={} TIMEOUT={} TARGET={}", this.mHandle, this.mTimeout, this.mReceiver.getTID());
    }

    void dismiss() {
        long nanos = CTimerManager.tick();
        LOG.debug("Dismiss Timer: ID={} TIMEOUT={} AFTER={}", this.mHandle, this.mTimeout, nanos - this.mLastTime);
    }

    long getHandle() {
        return this.mHandle;
    }

    long getTimeout() {
        return this.mTimeout;
    }

    boolean isRepeat() {
        return this.mRepeat;
    }

    public boolean match(IId aTID, IId aNID) {
        if (aTID == null) {
            return this.mReceiver.getNID().equals(aNID);
        }
        if (aNID == null) {
            return this.mReceiver.getTID().equals(aTID);
        }
        return this.mReceiver.getTID().equals(aTID) && this.mReceiver.getNID().equals(aNID);
    }

    boolean matchMTN(IId aMID, CTargetAddress aAddress) {
        return this.mMessageID.equals(aMID) && this.mReceiver.match(aAddress.getTID()) && this.mReceiver.matchNid(aAddress.getNID());
    }

    boolean matchTN(@NotNull CTargetAddress aAddress) {
        return this.mReceiver.match(aAddress.getTID()) && this.mReceiver.matchNid(aAddress.getNID());
    }

    void reset() {
        this.mLastTime = CTimerManager.tick();
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("TimerEntry ");
        sb.append(this.mHandle);
        sb.append(": ");
        if (this.mRepeat) {
            sb.append("all ");
        } else {
            sb.append("once after ");
        }
        sb.append(this.mTimeout);
        sb.append(" ms for ");
        sb.append(this.mReceiver.toString());
        sb.append('.');
        return sb.toString();
    }

    boolean trigger() throws CException {
        long time = CTimerManager.tick();
        if (time >= this.mLastTime + this.mTimeout) {
            CEnvelope env = new CEnvelope();
            CRecord rec = new CRecord(this.mMessageID);
            CRecordTimer.setOwner(rec, this.mReceiver);
            CRecordTimer.setRepeatedTimer(rec, this.mRepeat);
            CRecordTimer.setTimeout(rec, this.mTimeout);
            CRecordTimer.setTimerHandle(rec, this.mHandle);
            CRecordTimer.setCounter(rec, this.mCounter);
            if (this.mRecord != null) {
                rec.takeSlots(this.mRecord);
            }
            env.setSender(this.mTimerService.getSenderAddress());
            env.setReceiver(this.mReceiver);
            LOG.debug("Send Timer: ID={}, Timeout={}, Receiver={}.", this.mHandle, this.mTimeout, this.mReceiver);
            this.mTimerService.getSender().send(env, rec);
            this.mLastTime = time;
            ++this.mCounter;
            return !this.mRepeat;
        }
        return false;
    }
}

