/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.message;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRoutingHint {
    @NotNull
    private final CNodeAddress mAddressOfUnknownNode;
    @NotNull
    private final CNodeId mIdOfBridgeNode;

    public CRoutingHint(@NotNull CNodeAddress aAddressOfUnknownNode, @NotNull CNodeId aIdOfBridgeNode) {
        this.mAddressOfUnknownNode = aAddressOfUnknownNode;
        this.mIdOfBridgeNode = aIdOfBridgeNode;
    }

    @Nullable
    public static CRoutingHint fromStream(@NotNull DataInput aStream) throws IOException {
        CNodeAddress address = CNodeAddress.fromStream(aStream);
        CNodeId id = CNodeId.fromStream(aStream);
        if (address != null && id != null) {
            return new CRoutingHint(address, id);
        }
        return null;
    }

    @NotNull
    public CNodeAddress getAddressOfUnknownNode() {
        return this.mAddressOfUnknownNode;
    }

    @NotNull
    public CNodeId getIdOfBridgeNode() {
        return this.mIdOfBridgeNode;
    }

    public boolean equals(Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CRoutingHint that = (CRoutingHint)aOther;
        return this.mAddressOfUnknownNode.equals(that.mAddressOfUnknownNode);
    }

    public int hashCode() {
        return Objects.hash(this.mAddressOfUnknownNode);
    }

    public void toStream(@NotNull DataOutput aDos) throws IOException {
        CNodeAddress.toStream(aDos, this.mAddressOfUnknownNode);
        CNodeId.toStream(aDos, this.mIdOfBridgeNode);
    }

    public String toString() {
        return String.valueOf(this.mIdOfBridgeNode) + " --> " + String.valueOf(this.mAddressOfUnknownNode);
    }
}

