/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.nanoservice.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNanoServiceTriggerRecall
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("87c5e085-1ee4-4aa9-ac65-065d3ad994fe");
    public static final String NAME = "NanoServiceTriggerRecall";
    public static final String DESCRIPTION = "Get the last trigger for the nano service.";
    public static final String SLOT_ALL_OBSERVER = "all";
    public static final String SLOT_NID = "nid";
    public static final String SLOT_SID = "sid";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getAllObserver(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ALL_OBSERVER);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static IId getNid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static IId getSid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static void setAllObserver(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_ALL_OBSERVER, slot);
    }

    public static void setNid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_NID, slot);
    }

    public static void setSid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_SID, slot);
    }
}

