/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.stringrecord.CStringRecord;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CUtilChar {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilChar.class);

    private CUtilChar() {
    }

    public static char fromString(String aValue) {
        char result = '\u0000';
        if (!CUtilString.isEmpty(aValue)) {
            result = aValue.charAt(0);
        }
        return result;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static String toString(char aValue) {
        return Character.toString(aValue);
    }

    @NotNull
    public static String toStringRecord(short aType, char aValue) {
        String key = Short.toString(aType);
        String value = CUtilChar.toString(aValue);
        CStringRecord r = new CStringRecord(key, value);
        return r.getRecordString();
    }

    public static char fromObject(Object aValue, char aDefault) {
        char result = aDefault;
        if (aValue != null) {
            if (aValue instanceof Float) {
                result = (char)((Float)aValue).floatValue();
            } else if (aValue instanceof Double) {
                result = (char)((Double)aValue).doubleValue();
            } else if (aValue instanceof Short) {
                result = (char)((Short)aValue).shortValue();
            } else if (aValue instanceof Integer) {
                result = (char)((Integer)aValue).intValue();
            } else if (aValue instanceof Long) {
                result = (char)((Long)aValue).longValue();
            } else if (aValue instanceof Byte) {
                result = (char)((Byte)aValue).byteValue();
            } else if (aValue instanceof Character) {
                result = ((Character)aValue).charValue();
            } else if (aValue instanceof String) {
                result = CUtilChar.fromString((String)aValue);
            } else {
                LOG.error("Can't convert object {} to char. Take default value '0'", aValue);
            }
        }
        return result;
    }

    public static char random() {
        return (char)(CUtilRandom.getRandom().nextInt(26) + 97);
    }
}

