/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.stringrecord.CStringRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilFloat {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilFloat.class);
    private static final float DEFAULT_FLOAT = 0.0f;

    private CUtilFloat() {
    }

    public static float fromObject(@Nullable Object aValue) {
        return CUtilFloat.fromObject(aValue, 0.0f);
    }

    public static float fromObject(@Nullable Object aValue, float aDefault) {
        float result = 0.0f;
        if (aValue != null) {
            if (aValue instanceof Float) {
                result = ((Float)aValue).floatValue();
            } else if (aValue instanceof Double) {
                result = (float)((Double)aValue).doubleValue();
            } else if (aValue instanceof Short) {
                result = ((Short)aValue).shortValue();
            } else if (aValue instanceof Integer) {
                result = ((Integer)aValue).intValue();
            } else if (aValue instanceof Long) {
                result = ((Long)aValue).longValue();
            } else if (aValue instanceof Byte) {
                result = ((Byte)aValue).byteValue();
            } else if (aValue instanceof Character) {
                result = ((Character)aValue).charValue();
            } else if (aValue instanceof String) {
                result = CUtilFloat.fromString((String)aValue);
            } else {
                LOG.error("Can't convert object {} to float. Take default value '0.0f'", aValue);
            }
        }
        return result;
    }

    public static float fromString(@Nullable String aValue) {
        float result;
        if (aValue == null) {
            result = 0.0f;
        } else {
            try {
                result = Float.parseFloat(aValue);
            }
            catch (NumberFormatException e) {
                result = 0.0f;
            }
        }
        return result;
    }

    @NotNull
    public static String toString(float aValue) {
        return Float.toString(aValue);
    }

    @NotNull
    public static String toString(float aValue, int aMaxLen) {
        String result = CUtilFloat.toString(aValue);
        result = CUtilString.shortenString(result, aMaxLen);
        return result;
    }

    @NotNull
    public static String toStringRecord(short aType, float aValue) {
        String key = Short.toString(aType);
        String value = CUtilFloat.toString(aValue);
        CStringRecord r = new CStringRecord(key, value);
        return r.getRecordString();
    }

    public static float fromStream(@NotNull DataInput aStream) throws IOException {
        return aStream.readFloat();
    }

    public static void toStream(@NotNull DataOutput aStream, float aValue) throws IOException {
        aStream.writeFloat(aValue);
    }

    public static float random() {
        return CUtilRandom.getRandom().nextFloat();
    }
}

