/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilReflection {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilReflection.class);

    private CUtilReflection() {
    }

    @Nullable
    public static Object getValueOfConstant(@NotNull Class<?> aClass, @NotNull String aConstantName, Object aDefault, boolean aOnlyAccessible, boolean aIgnoreCase, String aPrefix) {
        try {
            Field[] fields;
            for (Field f : fields = aClass.getFields()) {
                if (!aOnlyAccessible) {
                    f.setAccessible(true);
                }
                String name = f.getName();
                if (aPrefix != null && !name.startsWith(aPrefix)) continue;
                if (aIgnoreCase && name.equalsIgnoreCase(aConstantName)) {
                    return f.get(null);
                }
                if (!name.equals(aConstantName)) continue;
                return f.get(null);
            }
        }
        catch (Exception e) {
            LOG.error(e, "Exception on getting the constants of Class {}", aClass.getName());
        }
        return aDefault;
    }
}

