/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.hash.CMd5;
import de.sillysky.nyssr.util.string.CUtilBase64;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilMd5 {
    private static final int SIZE = 16;
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilMd5.class);
    private static final int BUFSIZE = 262144;

    private CUtilMd5() {
    }

    @Nullable
    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("No MD5 MessageDigest found.");
            return null;
        }
    }

    @Nullable
    public static CMd5 calculate(byte[] aData) {
        MessageDigest md;
        CMd5 result = null;
        if (aData != null && (md = CUtilMd5.getMessageDigest()) != null) {
            md.update(aData, 0, aData.length);
            byte[] md5 = md.digest();
            result = CMd5.create(md5);
        }
        return result;
    }

    @Nullable
    public static CMd5 calculate(byte[] aData, byte[] aSalt) {
        MessageDigest md;
        CMd5 result = null;
        if (aData != null && (md = CUtilMd5.getMessageDigest()) != null) {
            md.update(aData, 0, aData.length);
            if (aSalt != null && aSalt.length > 0) {
                md.update(aSalt, 0, aSalt.length);
            }
            byte[] md5 = md.digest();
            result = CMd5.create(md5);
        }
        return result;
    }

    @Nullable
    public static CMd5 calculate(byte[] aData, int aPosition, int aLength) {
        MessageDigest md;
        CMd5 result = null;
        if (aData != null && (md = CUtilMd5.getMessageDigest()) != null) {
            md.update(aData, aPosition, aLength);
            byte[] md5 = md.digest();
            result = CMd5.create(md5);
        }
        return result;
    }

    @Nullable
    public static CMd5 calculate(@Nullable File aFile, byte[] aSalt) {
        MessageDigest md;
        CMd5 result = null;
        if (aFile != null && aFile.isFile() && aFile.canRead() && (md = CUtilMd5.getMessageDigest()) != null) {
            long time = 0L;
            if (LOG.isTraceEnabled()) {
                time = System.nanoTime();
            }
            try (FileInputStream fis = new FileInputStream(aFile);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                int read;
                byte[] buffer = new byte[262144];
                while ((read = fis.read(buffer)) > 0) {
                    md.update(buffer, 0, read);
                }
                bis.close();
                if (aSalt != null && aSalt.length > 0) {
                    md.update(aSalt, 0, aSalt.length);
                }
                byte[] digest = md.digest();
                result = CMd5.create(digest);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("MD5 calculateted for {} in {} nano seconds.", aFile.getPath(), System.nanoTime() - time);
            }
        }
        return result;
    }

    @NotNull
    public static String getString(byte[] aMd5) {
        if (aMd5 == null) {
            return "null";
        }
        return CUtilByteArray.toString(aMd5, '\u0000', 0);
    }

    public static boolean isValid(byte[] aHash) {
        if (aHash == null || aHash.length != 16) {
            return false;
        }
        for (byte b : aHash) {
            if (b == 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String toBase64(byte[] aDigest) {
        return CUtilBase64.encodeToString(aDigest);
    }

    public static byte[] fromBase64(@NotNull String aBase64) {
        return CUtilBase64.decode(aBase64);
    }

    @NotNull
    public static String encodeToHtmlId(@NotNull String aString) {
        byte[] bytes1 = aString.getBytes(StandardCharsets.UTF_8);
        CMd5 md5 = CUtilMd5.calculate(bytes1);
        byte[] bytes2 = md5 == null ? new byte[]{} : md5.getDigest();
        String s = CUtilBase64.encodeToString(bytes2);
        s = s.replace('+', '-');
        s = s.replace('=', '_');
        return s.replace('/', '_');
    }
}

