/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.job.serial;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.job.serial.INotifyJobsFinished;
import de.sillysky.nyssr.util.job.serial.ISerialJobQueueEntry;
import de.sillysky.nyssr.util.job.serial.ISerialJobQueueManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class CAbstractSerialJobManager
implements ISerialJobQueueManager {
    private static final ILogger LOG = CLoggerFactory.getLogger(CAbstractSerialJobManager.class);
    private final INotifyJobsFinished mParent;
    private final List<ISerialJobQueueEntry> mJobs = new CopyOnWriteArrayList<ISerialJobQueueEntry>();
    private ISerialJobQueueEntry mRunningJob = null;
    private int mCounter;

    public CAbstractSerialJobManager(@NotNull INotifyJobsFinished aParent) {
        this.mParent = aParent;
    }

    private void doStart() {
        if (!this.mJobs.isEmpty()) {
            this.mRunningJob = this.mJobs.remove(0);
            if (this.mRunningJob != null) {
                try {
                    ++this.mCounter;
                    this.mRunningJob.start();
                }
                catch (Exception aException) {
                    this.finish(2, aException.getMessage());
                }
            }
        }
    }

    @Override
    public void enqueueJob(@NotNull ISerialJobQueueEntry aJob) throws CException {
        String id = aJob.getId();
        this.mJobs.add(aJob);
    }

    @Override
    public void enqueueJobAndRun(@NotNull ISerialJobQueueEntry aJob) throws CException {
        this.enqueueJob(aJob);
        this.start();
    }

    @Override
    public void removeJob(@NotNull String aId) {
        this.mJobs.removeIf(job -> job.getId().equals(aId));
    }

    @Override
    public void removeJob(@NotNull ISerialJobQueueEntry aJob) {
        this.mJobs.removeIf(job -> job.equals(aJob));
    }

    @Override
    public void start() {
        if (this.mRunningJob == null) {
            this.doStart();
        }
    }

    @Override
    public void reset() {
        if (this.mRunningJob != null) {
            this.mRunningJob.stop();
            this.mRunningJob = null;
        }
        this.mJobs.clear();
    }

    @Override
    public boolean isJobQueueEmpty() {
        return this.mJobs.isEmpty();
    }

    @Override
    public void jobFinished(@NotNull ISerialJobQueueEntry aJob) {
        this.mRunningJob = null;
        if (this.mJobs.isEmpty()) {
            LOG.debug("{}: {} Jobs processed.", this.getJobManagerName(), this.mCounter);
        }
        this.doStart();
    }

    @Override
    public void finish(int aResultCode, @NotNull String aResultText) {
        this.reset();
        this.mParent.notifyJobsFinished(aResultCode, aResultText);
    }
}

