/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.properties.hierarchical;

import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.properties.hierarchical.CHierarchicalPropertyKey;
import de.sillysky.nyssr.util.properties.hierarchical.CHierarchicalPropertyMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHierarchicalProperty
extends CHierarchicalPropertyMap {
    @NotNull
    private final String mKey;
    @Nullable
    private String mValue;
    private boolean mDirty = true;

    public CHierarchicalProperty(@NotNull String aKey, @Nullable String aValue) {
        this.mKey = aKey;
        this.setValue(aValue);
    }

    public CHierarchicalProperty(@NotNull String aKey, @NotNull Map<String, CHierarchicalProperty> aChildren) {
        this.mKey = aKey;
        this.setValue(null);
        this.addAll(aChildren);
    }

    public CHierarchicalProperty(@NotNull String aKey) {
        this.mKey = aKey;
        this.setValue(null);
    }

    CHierarchicalProperty(@NotNull CHierarchicalProperty aOther) {
        super(aOther);
        this.mKey = aOther.mKey;
        this.setValue(aOther.mValue);
    }

    @Override
    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        if (!super.equals(aO)) {
            return false;
        }
        CHierarchicalProperty that = (CHierarchicalProperty)aO;
        return this.mKey.equals(that.mKey);
    }

    @NotNull
    public String getKey() {
        return this.mKey;
    }

    @Nullable
    public String getValue() {
        return this.mValue;
    }

    public void setValue(@Nullable String aValue) {
        this.mValue = aValue;
        this.setDirty(true);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mKey.hashCode();
        return result;
    }

    public boolean isDirty() {
        return this.mDirty;
    }

    public void setDirty(boolean aDirty) {
        this.mDirty = aDirty;
    }

    public String toString() {
        return this.mKey + " = " + this.mValue + " (" + this.mDirty + ", " + this.size() + ")";
    }

    @Override
    public CStringProperties toStringProperties() {
        CStringProperties sp = new CStringProperties();
        sp.put(this.mKey, this.mValue == null ? "" : this.mValue);
        this.toStringProperties(new CHierarchicalPropertyKey(this.mKey), sp);
        return sp;
    }
}

